<div class="lkRight">
    <div class="container-fluid">
        <h2 class="capTitle">Withdrawal History</h2>
        <?php
        // Query to fetch withdrawal history for the logged-in user
        $withdrawal_query = $conn->prepare("SELECT * FROM withdrawals WHERE userid = ?");
        $withdrawal_query->bind_param("i", $userid);
        $withdrawal_query->execute();
        $withdrawal_result = $withdrawal_query->get_result();

        // Check if there are any withdrawals
        if ($withdrawal_result->num_rows > 0) {
            echo "<div class='table-responsive'>";
            echo "<table class='table'>";
            echo "<thead><tr><th>Withdrawal ID</th><th>Amount</th><th>Date</th></tr></thead>";
            echo "<tbody>";
            while ($withdrawal = $withdrawal_result->fetch_assoc()) {
                echo "<tr>";
                echo "<td>{$withdrawal['withdrawal_id']}</td>";
                echo "<td>$" . $withdrawal['amount'] . "</td>";
                echo "<td>{$withdrawal['created_at']}</td>";
                echo "</tr>";
            }
            echo "</tbody>";
            echo "</table>";
            echo "</div>";
        } else {
            echo "No withdrawal history available.";
        }
        ?>
        
        <h2 class="capTitle">Withdraw Funds</h2>
        <form action="withdraw_process.php" method="post">
            <div class="form-group">
                <label for="amount">Amount to Withdraw ($)</label>
                <input type="number" class="form-control" id="amount" name="amount" placeholder="Enter amount" required>
            </div>
            <button type="submit" class="btn btn-primary">Withdraw</button>
        </form>
    </div>
</div>
