<?php
// Start the session
session_start();

// Check if the 'userid' session is not set
if (!isset($_SESSION['userid'])) {
    header("Location: ./login.php");
    exit();
}

// Include database connection and other necessary files
include_once ('_db.php');

// Set the user ID from the session variable
$userid = $_SESSION['userid'];

// Check if form data is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Retrieve user ID
    $userid = $_POST['userid'];

    // Retrieve withdrawal amount
    $withdrawalAmount = $_POST['amount'];

    // Query to retrieve user's account balance
    $stmt = $conn->prepare("SELECT account_balance FROM user_login WHERE userid = ?");
    $stmt->bind_param("i", $userid);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();

    // Check if withdrawal amount is greater than account balance
    if ($withdrawalAmount > $row['account_balance']) {
        // Insufficient balance, display error message
        echo "Insufficient balance. Please enter an amount less than or equal to your account balance.";
    } else {
        // Sufficient balance, proceed with withdrawal process
        // Add your withdrawal process code here
    }

    // Close statement
    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <title>Bitmaven</title>
    <meta content="width=1200" name="viewport">
    <meta name="format-detection" content="telephone=no">

    <link rel="shortcut icon" href="favicon.ico" type="image/x-icon">
    <link rel="icon" href="favicon.ico" type="image/x-icon">

    <link rel="stylesheet" type="text/css" href="fonts/icomoon/style.css" />
    <link rel="stylesheet" type="text/css" href="fonts/stylesheet.css" />
    <link rel="stylesheet" type="text/css" href="css/jquery-ui.min.css" />
    <link rel="stylesheet" type="text/css" href="css/selectric.css" />
    <link rel="stylesheet" type="text/css" href="css/owl.carousel.min.css" />
    <link rel="stylesheet" type="text/css" href="css/animate.css" />
    <link rel="stylesheet" type="text/css" href="css/style.css" />
    <link rel="stylesheet" type="text/css" href="css/responsive.css" />

    <script type="text/javascript" src="js/jquery-3.3.1.min.js"></script>
    <script type="text/javascript" src="js/detect.min.js"></script>
    <script type="text/javascript" src="js/jquery-ui.min.js"></script>
    <script type="text/javascript" src="js/jquery.selectric.min.js"></script>
    <script type="text/javascript" src="js/owl.carousel.min.js"></script>
    <script type="text/javascript" src="js/clipboard.min.js"></script>
    <script type="text/javascript" src="js/wow.min.js"></script>
    <script type="text/javascript" src="js/clock.js"></script>
    <script type="text/javascript" src="js/modal.js"></script>

    
    <script type="text/javascript" src="js/script.js"></script>
    <script src="//code.jivosite.com/widget/jaS5xGD7Od" async></script>
</head>
<body>
    <section class="wrapper">
                    <div class="lkPage">
                <div class="lineLeftLk">
                    <div class="logo invsLink">
                        <a href="dashboard.php?a=home"></a>
                        <img src="img/logo.png" alt="">
                    </div>
                    <button class="menuBtn">
                        <span></span>
                        <span></span>
                        <span></span>
                        <span></span>
                    </button>
                    <div class="menuLk">
                    <ul>
                            <li class="invisLink active">
                                <a href="dashboard.php?a=account"></a>
                                <span class="iconBl icon-user-icon-3"></span>
                                <span class="txt">user<br> area</span>
                            </li>
                            <li class="invisLink">
                                <a href="deposit.php?a=deposit"></a>
                                <span class="iconBl icon-plus-icon"></span>
                                <span class="txt">make a<br> deposit</span>
                            </li>
                            <li class="invisLink">
                                <a href="inevest_now.php?a=deposit"></a>
                                <span class="iconBl icon-plus-icon"></span>
                                <span class="txt">make a<br> Invesment</span>
                            </li>
                            <li class="invisLink">
                                <a href="transaction.php?a=deposit_list"></a>
                                <span class="iconBl icon-files-and-folders-1"></span>
                                <span class="txt">your<br> deposit</span>
                            </li>
                            <li class="invisLink">
                                <a href="withdraw.php?a=withdraw"></a>
                                <span class="iconBl icon-business-and-finance-3"></span>
                                <span class="txt">withdraw<br> funds</span>
                            </li>
                            <li class="invisLink">
                                <a href="transaction.php?a=earnings"></a>
                                <span class="iconBl icon-time-and-date-1"></span>
                                <span class="txt">operation<br> history</span>
                            </li>
                            <!-- <li class="invisLink">
                                <a href="?a=referals"></a>
                                <span class="iconBl icon-business-and-finance-2"></span>
                                <span class="txt">referral<br> system</span>
                            </li> -->
                            <!-- <li class="invisLink">
                                <a href="?a=wallet"></a>
                                <span class="iconBl icon-maps-and-location"></span>
                                <span class="txt">connect<br> wallet</span>
                            </li> -->
                            <!-- <li class="invisLink">
                                <a href="?a=edit_account"></a>
                                <span class="iconBl icon-ui"></span>
                                <span class="txt">user<br> settings</span>
                            </li> -->
                            <!--<li class="invisLink">
                                <a href="?a=tell_friend"></a>
                                <span class="iconBl icon-business-and-finance-2"></span>
                                <span class="txt">Tell<br> friend</span>
                            </li>-->
                            <li class="invisLink">
                                <a href="logout.php?a=logout"></a>
                                <span class="iconBl icon-placeholder-44"></span>
                                <span class="txt">Logout</span>
                            </li>                            
                        </ul>
                    </div>
                </div>
                <div class="lkLeft">
                <div class="welcomeBl">
                        
                <?php
                    // Assume $userid is the user's ID you want to retrieve details for

                    // Execute query to retrieve user information from user_login table based on userid
                    $sql = $conn->prepare("SELECT username, account_balance, created_at FROM user_login WHERE userid = ?");
                    $sql->bind_param("i", $userid);
                    $sql->execute();
                    $result = $sql->get_result();

                    // Check if there are any rows returned by the query
                    if ($result->num_rows > 0) {
                        // Fetch the row from the result set
                        $row = $result->fetch_assoc();
                        ?>
                        <span class="desr">Welcome,</span>
                        <span class="name"><?php echo $row['username']; ?></span>
                        <ul>
                            <li>
                                <span class="tit">Registration date:</span>
                                <span class="time"><?php echo date('M-d-Y', strtotime($row['created_at'])); ?></span>
                            </li>
                            
                        </ul>
                        <a href="index.php?a=home" class="btn btnYellow">Main page</a>
                </div>
                <div class="balanceBl" id="balance">
                            <span class="tit">Your balance:</span>
                            <span class="value">$ <?php echo number_format($row['account_balance'], 2); ?></span>
                            <!-- <span class="value"></?php echo $row['username']; ?></span> -->
                        </div>
                        <?php
                        }
                        ?>                  
                        <div class="listBalance" id="infodata">
                                                    <div class="item">
                                <span class="iconBl" style="background-image: url(img/ps_g/18.png);"></span>
                                <span class="val">0.00 <span class="cur">$</span></span>
                            </div>
                                                    <div class="item">
                                <span class="iconBl" style="background-image: url(img/ps_g/43.png);"></span>
                                <span class="val">0.00 <span class="cur">$</span></span>
                            </div>
                                                    <div class="item">
                                <span class="iconBl" style="background-image: url(img/ps_g/48.png);"></span>
                                <span class="val">0.00 <span class="cur">$</span></span>
                            </div>
                                                    <div class="item">
                                <span class="iconBl" style="background-image: url(img/ps_g/68.png);"></span>
                                <span class="val">0.00 <span class="cur">$</span></span>
                            </div>
                                                    <div class="item">
                                <span class="iconBl" style="background-image: url(img/ps_g/79.png);"></span>
                                <span class="val">0.00 <span class="cur">$</span></span>
                            </div>
                                                    <div class="item">
                                <span class="iconBl" style="background-image: url(img/ps_g/69.png);"></span>
                                <span class="val">0.00 <span class="cur">$</span></span>
                            </div>
                                                    <div class="item">
                                <span class="iconBl" style="background-image: url(img/ps_g/77.png);"></span>
                                <span class="val">0.00 <span class="cur">$</span></span>
                            </div>
                             </div>
                </div>

  <div class="lkRight">
<h2 class="capTitle">Withdraw funds</h2>


<?php
session_start();

// Check if withdrawal success message is set
if (isset($_SESSION['withdrawal_success'])) {
    echo '<div class="alert alert-success" role="alert" style="background-color: #d4edda; border-color: #c3e6cb; color: #155724;">';
    echo $_SESSION['withdrawal_success'];
    echo '</div>';
    // Unset the session variable to avoid displaying the message again on refresh
    unset($_SESSION['withdrawal_success']);
}

// Check if withdrawal error message is set
if (isset($_SESSION['withdrawal_error'])) {
    echo '<div class="alert alert-danger" role="alert" style="background-color: #f8d7da; border-color: #f5c6cb; color: #721c24;">';
    echo $_SESSION['withdrawal_error'];
    echo '</div>';
    // Unset the session variable to avoid displaying the message again on refresh
    unset($_SESSION['withdrawal_error']);
}
?>


<?php
// Assume $account_balance is the balance of the logged-in user retrieved from the database
$account_balance = 100.00; // Example balance

// Check if the user has funds available
if ($account_balance > 0) {
    // User has funds available, display the withdrawal form with the input field for entering the withdrawal amount
?>
   <form method="post" action="withdrawal_process.php" class="payOut">
    <input type="hidden" name="userid" value="<?php echo $_SESSION['userid']; ?>">
    <div class="withBl">    
        <div class="right">
            <!-- <h2 class="capTitleIn">Make A Withdrawal</h2> -->
            <div class="col">
                <div class="inputLine">
                    <label for="calc_amount">WALLET ADDRESS</label>
                    <input type="text" name="wallet_address" class="enter address">
                </div>
            </div>
            <div class="col">
                <div class="inputLine">
                    <label for="withdrawal_amount">Amount:</label>
                    <input type="text" name="amount" value="0.00" id="withdrawal_amount" class="enterNum">
                    <span class="cur">$</span>
                </div>
                <div id="balance_error" style="color: red;"></div> <!-- Error message placeholder -->
            </div>
            <div class="bot">
                <button type="submit" id="withdraw_button" class="btn btnGreen" disabled>Withdraw</button>
            </div>
        </div>
    </div>
</form>


<script>
// Function to check if withdrawal amount exceeds account balance and enable/disable Withdraw button
function validateWithdrawalAmount() {
    var withdrawalAmount = parseFloat(document.getElementById('withdrawal_amount').value);
    var accountBalance = <?php echo $row['account_balance']; ?>; // PHP variable containing account balance
    var withdrawButton = document.getElementById('withdraw_button');

    // Check if withdrawal amount is greater than account balance
    if (withdrawalAmount > accountBalance) {
        document.getElementById('balance_error').innerHTML = "Insufficient balance. Please enter an amount less than or equal to your account balance.";
        withdrawButton.disabled = true; // Disable the button
    } else {
        document.getElementById('balance_error').innerHTML = ""; // Clear error message
        withdrawButton.disabled = false; // Enable the button
    }
}

// Attach event listener to withdrawal amount input field
document.getElementById('withdrawal_amount').addEventListener('input', validateWithdrawalAmount);
</script>


<?php
} else {
    // User has no funds available, display a message
?>
    <div class="right">
        <h2 class="capTitleIn">Enter amount</h2>
        <br><br>
        You have no funds to withdraw.
    </div>
<?php
}
?>



 
     </div>
 <div class="lineRightLk">
                <div class="infoLine">
                    <div class="top">
                        <div class="socialBl">
                            <ul>
                               
                                <li><a href="#"><span class="iconBl icon-telegram"></span></a></li>
                                    
                            </ul>
                        </div>
                        <div class="timeBlock">
                            <span class="iconBl icon-clock-29"></span>
                            <span id="date"><span></span></span>
                            <span id="time"><span><span class="dot">:</span><span class="dot">:</span></span></span>
                        </div>
                        <div class="linksBlock">
                            <ul>
                                
                                <li>
                                    <span class="iconBl icon-mail-6"></span>
                                    <span class="tit">E-mail: </span>
                                    <a href="mailto:bitmaven01@gmail.com" class="mail">bitmaven01@gmail.com</a>
                                </li>
                                <li>
                                    <span class="iconBl icon-calendar-50"></span>
                                    <span class="tit">Working days: </span>
                                    <span class="txt">Daily<br> 24/7</span>
                                </li>
                            </ul>
                        </div>
                        <div class="copy"><p> Copyright &copy;2008 <br> Eco Trade Option</p></div>
                    </div>
                </div>
            </div>
        </div>
    </section>

            <script>
            $('#balance').hide();
            $('#infodata').hide();
            $.ajax({
                url: "?a=account",
                context: document.body
            }).done(function(data) {
                $('#balance').html($(data).find('#balance').html()).show();
                $('#infodata').html($(data).find('#infodata').html()).show();
            });
        </script>
       
    </body>
    
</html>
