<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Email Verification</title>
    <style>
        body {
    font-family: Arial, sans-serif;
    margin: 0;
    padding: 0;
    display: flex;
    justify-content: center;
    align-items: center;
    height: 100vh;
    background-color: #f4f4f4;
}

.container {
    background-color: #fff;
    padding: 20px;
    border-radius: 5px;
    box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    text-align: center;
}

h1 {
    color: #333;
}

p {
    color: #666;
    margin-bottom: 20px;
}

a {
    color: #007bff;
    text-decoration: none;
}

a:hover {
    text-decoration: underline;
}

    </style>
</head>
<body>
    <div class="container">
        <?php
        require_once('_db.php');

        // Check if the userid is sent via GET method
        if(isset($_GET['userid'])) {
            // Retrieve userid from GET parameters
            $userid = $_GET['userid'];
            
            // Update user's verification status in the database
            $stmt = $conn->prepare("UPDATE user_login SET status = 'active' WHERE userid = ?");
            $stmt->bind_param("s", $userid);
            if($stmt->execute()) {
                // Verification successful
                echo "<h1>Verification Successful</h1>";
                echo "<p>Your account has been successfully verified.</p>";
                echo "<p>You can now <a href='login.php'>login</a> to your account.</p>";
            } else {
                // Verification failed
                echo "<h1>Verification Failed</h1>";
                echo "<p>There was an error verifying your account. Please contact support for assistance.</p>";
            }
            // Close statement
            $stmt->close();
            // Close connection
            $conn->close();
        } else {
            // No userid sent via GET method
            echo "<h1>Error</h1>";
            echo "<p>Invalid verification link.</p>";
        }
        ?>
    </div>
</body>
</html>
