<?php
// Start the session
session_start();

// Check if the 'userid' session is not set
if (!isset($_SESSION['userid'])) {
    header("Location: ./login.php");
    exit();
}

// Include database connection and other necessary files
include_once ('_db.php');

// Set the user ID from the session variable
$userid = $_SESSION['userid'];

?>


<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <title>Bitmaven</title>
    <meta content="width=1200" name="viewport">
    <meta name="format-detection" content="telephone=no">

    <link rel="shortcut icon" href="favicon.ico" type="image/x-icon">
    <link rel="icon" href="favicon.ico" type="image/x-icon">

    <link rel="stylesheet" type="text/css" href="fonts/icomoon/style.css" />
    <link rel="stylesheet" type="text/css" href="fonts/stylesheet.css" />
    <link rel="stylesheet" type="text/css" href="css/jquery-ui.min.css" />
    <link rel="stylesheet" type="text/css" href="css/selectric.css" />
    <link rel="stylesheet" type="text/css" href="css/owl.carousel.min.css" />
    <link rel="stylesheet" type="text/css" href="css/animate.css" />
    <link rel="stylesheet" type="text/css" href="css/style.css" />
    <link rel="stylesheet" type="text/css" href="css/responsive.css" />

    <script type="text/javascript" src="js/jquery-3.3.1.min.js"></script>
    <script type="text/javascript" src="js/detect.min.js"></script>
    <script type="text/javascript" src="js/jquery-ui.min.js"></script>
    <script type="text/javascript" src="js/jquery.selectric.min.js"></script>
    <script type="text/javascript" src="js/owl.carousel.min.js"></script>
    <script type="text/javascript" src="js/clipboard.min.js"></script>
    <script type="text/javascript" src="js/wow.min.js"></script>
    <script type="text/javascript" src="js/clock.js"></script>
    <script type="text/javascript" src="js/modal.js"></script>

    
    <script type="text/javascript" src="js/script.js"></script>
    <script src="//code.jivosite.com/widget/jaS5xGD7Od" async></script>

</head>
<body>
    <section class="wrapper">
                    <div class="lkPage">
                <div class="lineLeftLk">
                    <div class="logo invsLink">
                        <a href="dasboard.php?a=home"></a>
                        <img src="img/logo.png" alt="">
                    </div>
                    <button class="menuBtn">
                        <span></span>
                        <span></span>
                        <span></span>
                        <span></span>
                    </button>
                    <div class="menuLk">
                    <ul>
                            <li class="invisLink active">
                                <a href="dashboard.php?a=account"></a>
                                <span class="iconBl icon-user-icon-3"></span>
                                <span class="txt">user<br> area</span>
                            </li>
                            <li class="invisLink">
                                <a href="deposit.php?a=deposit"></a>
                                <span class="iconBl icon-plus-icon"></span>
                                <span class="txt">make a<br> deposit</span>
                            </li>
                            <li class="invisLink">
                                <a href="inevest_now.php?a=deposit"></a>
                                <span class="iconBl icon-plus-icon"></span>
                                <span class="txt">make a<br> Invesment</span>
                            </li>
                            <li class="invisLink">
                                <a href="transaction.php?a=deposit_list"></a>
                                <span class="iconBl icon-files-and-folders-1"></span>
                                <span class="txt">your<br> deposit</span>
                            </li>
                            <li class="invisLink">
                                <a href="withdraw.php?a=withdraw"></a>
                                <span class="iconBl icon-business-and-finance-3"></span>
                                <span class="txt">withdraw<br> funds</span>
                            </li>
                            <li class="invisLink">
                                <a href="transaction.php?a=earnings"></a>
                                <span class="iconBl icon-time-and-date-1"></span>
                                <span class="txt">operation<br> history</span>
                            </li>
                            <!-- <li class="invisLink">
                                <a href="?a=referals"></a>
                                <span class="iconBl icon-business-and-finance-2"></span>
                                <span class="txt">referral<br> system</span>
                            </li> -->
                            <!-- <li class="invisLink">
                                <a href="?a=wallet"></a>
                                <span class="iconBl icon-maps-and-location"></span>
                                <span class="txt">connect<br> wallet</span>
                            </li> -->
                            <li class="invisLink">
                                <a href="?a=edit_account"></a>
                                <span class="iconBl icon-ui"></span>
                                <span class="txt">user<br> settings</span>
                            </li>
                            <!--<li class="invisLink">
                                <a href="?a=tell_friend"></a>
                                <span class="iconBl icon-business-and-finance-2"></span>
                                <span class="txt">Tell<br> friend</span>
                            </li>-->
                            <li class="invisLink">
                                <a href="logout.php?a=logout"></a>
                                <span class="iconBl icon-placeholder-44"></span>
                                <span class="txt">Logout</span>
                            </li>                            
                        </ul>
                </div>
            </div>
            <div class="lkLeft">
                <div class="welcomeBl">
                    <?php
                    // Assume $userid is the user's ID you want to retrieve details for

                    // Execute query to retrieve user information from user_login table based on userid
                    $sql = $conn->prepare("SELECT username, account_balance, created_at FROM user_login WHERE userid = ?");
                    $sql->bind_param("i", $userid);
                    $sql->execute();
                    $result = $sql->get_result();

                    // Check if there are any rows returned by the query
                    if ($result->num_rows > 0) {
                        // Fetch the row from the result set
                        $row = $result->fetch_assoc();
                        ?>
                        <span class="desr">Welcome,</span>
                        <span class="name"><?php echo $row['username']; ?></span>
                        <ul>
                            <li>
                                <span class="tit">Registration date:</span>
                                <span class="time"><?php echo date('M-d-Y', strtotime($row['created_at'])); ?></span>
                            </li>
                            <li>
                                <span class="tit">Last seen:</span>
                                <span class="time">n/a </span>
                            </li>
                        </ul>
                        <a href="index.php?a=home" class="btn btnYellow">Main page</a>
                </div>
                <div class="balanceBl" id="balance">
    <span class="tit">Your balance:</span>
    <span class="value">$ <?php echo number_format($row['account_balance'], 2); ?></span>
    <!-- <span class="value"></?php echo $row['username']; ?></span> -->
</div>
<?php
}
?>
                     <div class="listBalance" id="infodata">
                                                    <div class="item">
                                <span class="iconBl" style="background-image: url(img/ps_g/18.png);"></span>
                                <span class="val">0.00 <span class="cur">$</span></span>
                            </div>
                                                    <div class="item">
                                <span class="iconBl" style="background-image: url(img/ps_g/43.png);"></span>
                                <span class="val">0.00 <span class="cur">$</span></span>
                            </div>
                                                    <div class="item">
                                <span class="iconBl" style="background-image: url(img/ps_g/48.png);"></span>
                                <span class="val">0.00 <span class="cur">$</span></span>
                            </div>
                                                    <div class="item">
                                <span class="iconBl" style="background-image: url(img/ps_g/68.png);"></span>
                                <span class="val">0.00 <span class="cur">$</span></span>
                            </div>
                                                    <div class="item">
                                <span class="iconBl" style="background-image: url(img/ps_g/79.png);"></span>
                                <span class="val">0.00 <span class="cur">$</span></span>
                            </div>
                                                    <div class="item">
                                <span class="iconBl" style="background-image: url(img/ps_g/69.png);"></span>
                                <span class="val">0.00 <span class="cur">$</span></span>
                            </div>
                                                    <div class="item">
                                <span class="iconBl" style="background-image: url(img/ps_g/77.png);"></span>
                                <span class="val">0.00 <span class="cur">$</span></span>
                            </div>
                             </div>
                </div>
                <div class="lkRight">
    <div class="container-fluid">
    <h2 class="capTitle">Deposit History</h2>
<?php
// Query to fetch deposit history for the logged-in user
$deposit_query = $conn->prepare("SELECT * FROM deposit WHERE userid = ?");
$deposit_query->bind_param("i", $userid);
$deposit_query->execute();
$deposit_result = $deposit_query->get_result();

// Check if there are any deposits
if ($deposit_result->num_rows > 0) {
    echo "<div class='table-responsive'>";
    echo "<table class='table'>";
    echo "<thead><tr><th>Deposit ID</th><th>Type</th><th>Amount</th><th>Date</th></tr></thead>";
    echo "<tbody>";
    while ($deposit = $deposit_result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>{$deposit['deposit_id']}</td>";
        echo "<td>{$deposit['wallet_type']}</td>";
        echo "<td>$" . number_format($deposit['amount'], 2) . "</td>";
        echo "<td>{$deposit['created_at']}</td>";
        echo "</tr>";
    }
    echo "</tbody>";
    echo "</table>";
    echo "</div>";
} else {
    echo "No deposit history available.";
}
?>

    </div>      
</div>


<div class="lineRightLk">
                <div class="infoLine">
                    <div class="top">
                        <div class="socialBl">
                            <ul>
                                <li><a href="https://t.me/fzjoseph"><span class="iconBl icon-telegram"></span></a></li>
                            </ul>
                        </div>
                        <div class="timeBlock">
                            <span class="iconBl icon-clock-29"></span>
                            <span id="date"><span></span></span>
                            <span id="time"><span><span class="dot">:</span><span class="dot">:</span></span></span>
                        </div>
                        <div class="linksBlock">
                            <ul>
                                <li>
                                    <span class="iconBl icon-mail-6"></span>
                                    <span class="tit">E-mail: </span>
                                    <a href="mailto:bitmaven01@gmail.com" class="mail">bitmaven01@gmail.com</a>
                                </li>
                                <li>
                                    <span class="iconBl icon-calendar-50"></span>
                                    <span class="tit">Working days: </span>
                                    <span class="txt">Daily<br> 24/7</span>
                                </li>
                            </ul>
                        </div>
                        <div class="copy"><p>© 2013 - <script> document.write(new Date().getFullYear())</script> Copyright <a href="https://www.openartminting.art" class="light text-decoration-none">Wealthwisedigitalinvestment</a>. All rights reserved </p></div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <script>
        $('#balance').hide();
        $('#infodata').hide();
        $.ajax({
            url: "?a=account",
            context: document.body
        }).done(function(data) {
            $('#balance').html($(data).find('#balance').html()).show();
            $('#infodata').html($(data).find('#infodata').html()).show();
        });
    </script>
</body>
</html>