<?php
// Start the session
session_start();

// Check if the user is logged in
if (!isset($_SESSION['userid'])) {
    header("Location: login.php");
    exit();
}

// Include database connection and other necessary files
include_once('_db.php');

// Check if form data is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Retrieve form data
    $userid = $_SESSION['userid'];
    $planTitle = $_POST['plan_title'];
    $investmentAmount = $_POST['amount'];
    $totalProfit = $_POST['total_profit'];
    $walletType = $_POST['wallet_type']; // New field: Wallet Type

    // Handle uploaded file
    $targetDir = "uploads/"; // Directory where files will be uploaded
    $targetFile = $targetDir . basename($_FILES["proof_of_payment"]["name"]); // Path to uploaded file
    $uploadOk = 1; // Flag to indicate if file upload is successful
    $imageFileType = strtolower(pathinfo($targetFile, PATHINFO_EXTENSION)); // File extension

    // Check if file is a valid image
    if (isset($_POST["submit"])) {
        $check = getimagesize($_FILES["proof_of_payment"]["tmp_name"]);
        if ($check !== false) {
            echo "File is an image - " . $check["mime"] . ".";
            $uploadOk = 1;
        } else {
            echo "File is not an image.";
            $uploadOk = 0;
        }
    }

    // Check file size
    if ($_FILES["proof_of_payment"]["size"] > 500000) {
        echo "Sorry, your file is too large.";
        $uploadOk = 0;
    }

    // Allow only certain file formats
    if ($imageFileType != "jpg" && $imageFileType != "png" && $imageFileType != "jpeg"
        && $imageFileType != "gif") {
        echo "Sorry, only JPG, JPEG, PNG & GIF files are allowed.";
        $uploadOk = 0;
    }

    // Check if $uploadOk is set to 0 by an error
    if ($uploadOk == 0) {
        echo "Sorry, your file was not uploaded.";
        // if everything is ok, try to upload file
    } else {
        if (move_uploaded_file($_FILES["proof_of_payment"]["tmp_name"], $targetFile)) {
            echo "The file " . htmlspecialchars(basename($_FILES["proof_of_payment"]["name"])) . " has been uploaded.";
        } else {
            echo "Sorry, there was an error uploading your file.";
        }
    }

 
    // Fetch current account balance
    $balanceSql = "SELECT account_balance FROM user_login WHERE userid = '$userid'";
    $balanceResult = $conn->query($balanceSql);
    if ($balanceResult->num_rows > 0) {
        $row = $balanceResult->fetch_assoc();
        $currentBalance = $row["account_balance"];

        // Calculate new account_balance after deduction
        $newBalance = $currentBalance - $investmentAmount;

        // Update user's account account_balance
        $updateBalanceSql = "UPDATE user_login SET account_balance = '$newBalance' WHERE userid = '$userid'";
        if ($conn->query($updateBalanceSql) === TRUE) {
            echo "User's account account_balance updated successfully.";
        } else {
            echo "Error updating user's account account_balance: " . $conn->error;
        }
    } else {
        echo "Error: User not found.";
    }

    // Insert payment details into the database
    $insertSql = "INSERT INTO investments (userid, plan_title, amount, profit, wallet_type, proof_of_payment) 
                  VALUES ('$userid', '$planTitle', '$investmentAmount', '$totalProfit', '$walletType', '$targetFile')";
    if ($conn->query($insertSql) === TRUE) {
        echo "New record inserted successfully.";
    } else {
        echo "Error: " . $insertSql . "<br>" . $conn->error;
    }

    // Calculate the scheduled time for profit addition (current time + 24 hours)
    $scheduledTime = time() + (24 * 60 * 60);

    // Insert a record into the profit_additions table
    $profitSql = "INSERT INTO profit_additions (userid, profit, scheduled_time) VALUES ('$userid', '$totalProfit', '$scheduledTime')";
    if ($conn->query($profitSql) === TRUE) {
        echo "New profit addition record created successfully.";
    } else {
        echo "Error: " . $profitSql . "<br>" . $conn->error;
    }

    // Redirect to confirmation page with success status
    header("Location: confirmation_page.php?status=success");
    exit(); // Make sure to exit after redirection
}
?>
