<?php
// Start the session
session_start();

// Check if the user is logged in
if (!isset($_SESSION['userid'])) {
    header("Location: login.php");
    exit();
}

// Include database connection and other necessary files
include_once ('_db.php');

// Retrieve form data (assuming you passed it from the previous page)
$planTitle = $_POST['plan_title'] ?? '';
$investmentAmount = $_POST['amount'] ?? '';
$totalProfit = $_POST['total_profit'] ?? '';

// Calculate total profit
// Assuming you have the ROI for the selected plan available
// Replace $roi with the actual ROI value for the selected plan
$roi = 11; // Example ROI value, replace with actual value
$totalProfit = $investmentAmount * $roi;
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Payment Success</title>
    <!-- Include CSS and other necessary files -->
</head>
<body>
    <h1>Payment Successful</h1>
    <p>You have successfully made the payment.</p>
    <p>You selected the <?php echo $planTitle; ?> plan with an investment of $<?php echo $investmentAmount; ?>.</p>
    <p>Your total profit is $<?php echo number_format($totalProfit, 2); ?>.</p>
    
    <!-- Additional content or styling as needed -->
</body>
</html>
