$(document).ready(function () {

    var ua = detect.parse(navigator.userAgent);
    $("html").addClass(ua.device.type + " " + ua.device.family + " " + ua.os.family + " " + ua.browser.family)

    $(".menuBtn").on("click", function () {
        $(this).toggleClass("selected")
        if ($("header").length > 0) {
            $("body").toggleClass("hidden")
            $("header .infoLine").slideToggle().toggleClass("open")
        }
        if ($(".lkPage").length > 0) {
            $("body").toggleClass("hidden")
            $(".menuLk").slideToggle().toggleClass("open")
        }
    })

    if ($(".lkPage .balanceBl").length > 0) {
        balanceClick()
    }

    if ($(".timeBlock").length > 0) {
        clock();
    }

    if ($(".copyRef").length > 0) {
        new ClipboardJS('.copyRef');
    }

    if ($(".tabs").length > 0) {
        $(".tabs").map(function () {
            $(this).tabs();
        })
    }

    if ($(".selectricBl").length > 0) {
        $(".selectricBl").map(function () {
            $(this).selectric({
                onChange: function (elem) {
                    $(elem).change();
                }
            });
        })
    }

    if ($(".selectBlock").length > 0) {

        $('.depBlock').find('input:not(:disabled) + label').on('click', function () {
            var active = $(this).siblings('input').attr('data-index');
            if ($('.calcTotal').length > 0) {
                $(".calcTotal .selectricBl").prop('selectedIndex', active).selectric('refresh').change();
            }
        });

        $('.makeBl .selectBlock .item label').on('click', function () {

            var makeName = $(this).attr('data-name');
            var makePr = $(this).attr('data-pr');
            var makeDay = $(this).attr('data-day');
            var makeMin = $(this).attr('data-min');
            var makeMax = $(this).attr('data-max');
            $(".makeBl .info .name").text(makeName)
            $(".makeBl .info .pr").text(makePr)
            $(".makeBl .info .day").text(makeDay)
            $(".minvl").text(makeMin)
            $(".maxvl").text(makeMax)

        });

        if ($('.calcTotal .selectricBl').length > 0) {
            $('.calcTotal .selectricBl').map(function () {
                $(this).selectric({
                    onChange: function (elem) {
                        var changePl = $(this).prop('selectedIndex');
                        if (changePl < 7) {
                            var itemBl = $('.selectBlock .list').find('.item').eq(changePl);
                        } else {
                            var itemBl = $('.vipSelect').find('.item').eq(changePl - 7);
                        }
                        var input = itemBl.find("input")
                        input.prop('checked', true);
                        input.siblings('label').trigger('click');

                        $(elem).change();
                    }
                });
            });
        }

    }

    if ($(".investPage").length > 0) {

        $('.listCalcInvest').find('input:not(:disabled) + label').on('click', function () {
            var active = $(this).siblings('input').attr('data-index');
            $(".investPage .calcTotal .selectricBl").prop('selectedIndex', active).selectric('refresh');
        });

        if ($('.investPage .calcTotal .selectricBl').length > 0) {
            $('.investPage .calcTotal .selectricBl').map(function () {
                $(this).selectric({
                    onChange: function () {
                        var changePl = $(this).prop('selectedIndex');

                        var itemBl = $('.listCalcInvest').find('.item').eq(changePl);

                        var input = itemBl.find("input")
                        input.prop('checked', true);
                        input.siblings('label').trigger('click');
                    }
                });
            });
        }

    }

    if ($(".sliderReviews").length > 0) {
        sliderReviewsInit()
    }

    if ($(".yourRef").length > 0) {
        var timeOut = false;
        $(".yourRef .item").on("click", function () {
            if (timeOut) return false;
            $(this).toggleClass("active")
            $(this).find(".bot").slideToggle()
            timeOut = true;
            setTimeout(function () {
                timeOut = false;
            }, 500);

        })
    }

    if ($(".filterBl").length > 0) {
        var dateFormat = "dd.mm.yy",
            from = $("#from")
                .datepicker({
                    defaultDate: "+1w",
                    changeMonth: true,
                    numberOfMonths: 1,
                    dateFormat: "dd.mm.yy"
                })
                .on("change", function () {
                    to.datepicker("option", "minDate", getDate(this));
                }),
            to = $("#to").datepicker({
                defaultDate: "+1w",
                changeMonth: true,
                numberOfMonths: 1,
                dateFormat: "dd.mm.yy"
            })
                .on("change", function () {
                    from.datepicker("option", "maxDate", getDate(this));
                });

        function getDate(element) {
            var date;
            try {
                date = $.datepicker.parseDate(dateFormat, element.value);
            } catch (error) {
                date = null;
            }

            return date;
        }
    }

    if ($(window).width() > 1200) {
        if ($(".wow").length > 0) {
            new WOW().init();
        }
    }

    if ($(".modalsScroll").length > 0) {
        openMod();
    }

    // if ($(".modalsScroll").length > 0) {
    //     modalEventOpen("modal_dep")
    // }

    if ($(".listCurCircle").length > 0) {
        $('.listCurCircle').parallax({
            mouseport: $('body'),
            xparallax: '100px',
            yparallax: false,
            decay: 0.1,
            xorigin: 0
        });
    }

    if ($(".headerMain").length > 0) {
        headerCanvas()
        footerCanvas()
    }

    if ($(".lineSumma").length > 0) {
        lineSumma()
    }
})

$(window).resize(function () {
    balanceClick()
});


var sliderReviewsInit = function () {
    var owl = $('.sliderReviews');
    owl.owlCarousel({
        loop: true,
        nav: true,
        dots: false,
        navText: ['<span class="strLeft"></span>', '<span class="strRight"></span>'],
        responsive: {
            0: {
                items: 1,
                margin: 0,
            }
        }
    })
}


var balanceClick = function () {
    $(".lkPage .balanceBl").unbind('click');
    if ($(window).width() < 992) {
        var timeOut = false;
        $(".lkPage .balanceBl").on("click", function () {

            if (timeOut) return false;
            $(this).toggleClass("selected")
            $(".listBalance").slideToggle().toggleClass("open")
            timeOut = true;
            setTimeout(function () {
                timeOut = false;
            }, 500);


        })
    } else {
        $(".lkPage .balanceBl").unbind('click');
    }

}


var lineSumma = function () {

    $(".lineSumma .value .sum").html('');
    str = $(".lineSumma .value .sum").attr("data-sum").split('');
    $.each(str, function () {
        if (this == ".") {
            $(".lineSumma .value .sum").append('<span class="val toh">' + this + '</span>');
        } else {
            $(".lineSumma .value .sum").append('<span class="val">' + this + '</span>');
        }
    });

}