<!-- Your HTML code -->
<?php
// Start the session
session_start();

// Check if the 'userid' session is not set
if (!isset($_SESSION['userid'])) {
    header("Location: ./login.php");
    exit();
}

// Include database connection and other necessary files
include_once ('_db.php');

// Set the user ID from the session variable
$userid = $_SESSION['userid'];

?>


<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <title>Bitmaven </title>
    <meta content="width=1200" name="viewport">
    <meta name="format-detection" content="telephone=no">

    <link rel="shortcut icon" href="favicon.ico" type="image/x-icon">
    <link rel="icon" href="favicon.ico" type="image/x-icon">

    <link rel="stylesheet" type="text/css" href="fonts/icomoon/style.css" />
    <link rel="stylesheet" type="text/css" href="fonts/stylesheet.css" />
    <link rel="stylesheet" type="text/css" href="css/jquery-ui.min.css" />
    <link rel="stylesheet" type="text/css" href="css/selectric.css" />
    <link rel="stylesheet" type="text/css" href="css/owl.carousel.min.css" />
    <link rel="stylesheet" type="text/css" href="css/animate.css" />
    <link rel="stylesheet" type="text/css" href="css/style.css" />
    <link rel="stylesheet" type="text/css" href="css/responsive.css" />

    <script type="text/javascript" src="js/jquery-3.3.1.min.js"></script>
    <script type="text/javascript" src="js/detect.min.js"></script>
    <script type="text/javascript" src="js/jquery-ui.min.js"></script>
    <script type="text/javascript" src="js/jquery.selectric.min.js"></script>
    <script type="text/javascript" src="js/owl.carousel.min.js"></script>
    <script type="text/javascript" src="js/clipboard.min.js"></script>
    <script type="text/javascript" src="js/wow.min.js"></script>
    <script type="text/javascript" src="js/clock.js"></script>
    <script type="text/javascript" src="js/modal.js"></script>

    
    <script type="text/javascript" src="js/script.js"></script>
    <script src="//code.tidio.co/okcjoxpwqcqjojyqeqtoy15nqmc3h3tq.js" async></script>

</head>
<body>
    <section class="wrapper">
                    <div class="lkPage">
                <div class="lineLeftLk">
                    <div class="logo invsLink">
                        <a href="index.php?a=home"></a>
                        <img src="img/logo.png" alt="">
                    </div>
                    <button class="menuBtn">
                        <span></span>
                        <span></span>
                        <span></span>
                        <span></span>
                    </button>
                    <div class="menuLk">
                    <ul>
                            <li class="invisLink active">
                                <a href="dashboard.php?a=account"></a>
                                <span class="iconBl icon-user-icon-3"></span>
                                <span class="txt">user<br> area</span>
                            </li>
                            <li class="invisLink">
                                <a href="deposit.php?a=deposit"></a>
                                <span class="iconBl icon-plus-icon"></span>
                                <span class="txt">make a<br> deposit</span>
                            </li>
                            <li class="invisLink">
                                <a href="inevest_now.php?a=deposit"></a>
                                <span class="iconBl icon-plus-icon"></span>
                                <span class="txt">make a<br> Invesment</span>
                            </li>
                            <li class="invisLink">
                                <a href="transaction.php?a=deposit_list"></a>
                                <span class="iconBl icon-files-and-folders-1"></span>
                                <span class="txt">your<br> deposit</span>
                            </li>
                            <li class="invisLink">
                                <a href="withdraw.php?a=withdraw"></a>
                                <span class="iconBl icon-business-and-finance-3"></span>
                                <span class="txt">withdraw<br> funds</span>
                            </li>
                            <li class="invisLink">
                                <a href="transaction.php?a=earnings"></a>
                                <span class="iconBl icon-time-and-date-1"></span>
                                <span class="txt">operation<br> history</span>
                            </li>
                            <!-- <li class="invisLink">
                                <a href="?a=referals"></a>
                                <span class="iconBl icon-business-and-finance-2"></span>
                                <span class="txt">referral<br> system</span>
                            </li> -->
                            <!-- <li class="invisLink">
                                <a href="?a=wallet"></a>
                                <span class="iconBl icon-maps-and-location"></span>
                                <span class="txt">connect<br> wallet</span>
                            </li> -->
                            <li class="invisLink">
                                <a href="?a=edit_account"></a>
                                <span class="iconBl icon-ui"></span>
                                <span class="txt">user<br> settings</span>
                            </li>
                            <!--<li class="invisLink">
                                <a href="?a=tell_friend"></a>
                                <span class="iconBl icon-business-and-finance-2"></span>
                                <span class="txt">Tell<br> friend</span>
                            </li>-->
                            <li class="invisLink">
                                <a href="logout.php?a=logout"></a>
                                <span class="iconBl icon-placeholder-44"></span>
                                <span class="txt">Logout</span>
                            </li>                            
                        </ul>
                    </div>
                </div>
                <div class="lkLeft">
                    <div class="welcomeBl">
                        
                         <?php
                            // Assume $userid is the user's ID you want to retrieve details for

                            // Execute query to retrieve user information from user_login table based on userid
                            $stmt = $conn->prepare("SELECT username, account_balance, created_at FROM user_login WHERE userid = ?");
                            $stmt->bind_param("i", $userid);
                            $stmt->execute();
                            $result = $stmt->get_result()->fetch_assoc();
                            $stmt->close();

                            // Check if there are any rows returned by the query
                            if ($result) {
                            ?>
                                <span class="desr">Welcome,</span>
                                <span class="name"><?php echo $result['username']; ?></span>
                                <ul>
                                    <li>
                                        <span class="tit">Registration date:</span>
                                        <span class="time"><?php echo date('M-d-Y', strtotime($result['created_at'])); ?></span>
                                    </li>
                                    <li>
                                        <span class="tit">Last seen:</span>
                                        <span class="time">n/a </span>
                                    </li>
                                </ul>
                            

                        <a href="index.php?a=home" class="btn btnYellow">Main page</a>
                    </div>  
                    <div class="balanceBl" id="balance">
                            <span class="tit">Your balance:</span>
                            <!-- <span class="value">$ </?php echo number_format($row['account_balance'], 2); ?></span> -->
                            <span class="value">$ <?php echo number_format($result['account_balance'], 2); ?></span>

                            <!-- <span class="value"></?php echo $row['username']; ?></span> -->
                        </div>
                        <?php
                        }
                        ?>
                     <div class="listBalance" id="infodata">
                                                    <div class="item">
                                <span class="iconBl" style="background-image: url(img/ps_g/18.png);"></span>
                                <span class="val">0.00 <span class="cur">$</span></span>
                            </div>
                                                    <div class="item">
                                <span class="iconBl" style="background-image: url(img/ps_g/43.png);"></span>
                                <span class="val">0.00 <span class="cur">$</span></span>
                            </div>
                                                    <div class="item">
                                <span class="iconBl" style="background-image: url(img/ps_g/48.png);"></span>
                                <span class="val">0.00 <span class="cur">$</span></span>
                            </div>
                                                    <div class="item">
                                <span class="iconBl" style="background-image: url(img/ps_g/68.png);"></span>
                                <span class="val">0.00 <span class="cur">$</span></span>
                            </div>
                                                    <div class="item">
                                <span class="iconBl" style="background-image: url(img/ps_g/79.png);"></span>
                                <span class="val">0.00 <span class="cur">$</span></span>
                            </div>
                                                    <div class="item">
                                <span class="iconBl" style="background-image: url(img/ps_g/69.png);"></span>
                                <span class="val">0.00 <span class="cur">$</span></span>
                            </div>
                                                    <div class="item">
                                <span class="iconBl" style="background-image: url(img/ps_g/77.png);"></span>
                                <span class="val">0.00 <span class="cur">$</span></span>
                            </div>
                             </div>
                </div>
  <div class="lkRight">
        

<h2 class="capTitle">Make your Investment</h2>
    


<script language="javascript"><!--
function openCalculator(id)
{

  w = 225; h = 400;
  t = (screen.height-h-30)/2;
  l = (screen.width-w-30)/2;
  window.open('?a=calendar&type=' + id, 'calculator' + id, "top="+t+",left="+l+",width="+w+",height="+h+",resizable=1,scrollbars=0");


  
  for (i = 0; i < document.spendform.h_id.length; i++)
  {
    if (document.spendform.h_id[i].value == id)
    {
      document.spendform.h_id[i].checked = true;
    }
  }

  

}

function updateCompound() {
  var id = 0;
  var tt = document.spendform.h_id.type;
  if (tt && tt.toLowerCase() == 'hidden') {
    id = document.spendform.h_id.value;
  } else {
    for (i = 0; i < document.spendform.h_id.length; i++) {
      if (document.spendform.h_id[i].checked) {
        id = document.spendform.h_id[i].value;
      }
    }
  }

  var cpObj = document.getElementById('compound_percents');
  if (cpObj) {
    while (cpObj.options.length != 0) {
      cpObj.options[0] = null;
    }
  }

  if (cps[id] && cps[id].length > 0) {
    document.getElementById('coumpond_block').style.display = '';

    for (i in cps[id]) {
      cpObj.options[cpObj.options.length] = new Option(cps[id][i]);
    }
  } else {
    document.getElementById('coumpond_block').style.display = 'none';
  }
}
var cps = {};
--></script>

<?php
// Check if the status parameter is present in the URL
if (isset($_GET['status'])) {
    // Check the value of the status parameter
    $status = $_GET['status'];
    if ($status === "success") {
        // Display success message with green background
        echo '<div class="alert alert-success" role="alert" style="background-color: #d4edda; border-color: #c3e6cb; color: #155724;">';
        echo 'Success! Your wallet will be credited once admin confirms your payment.';
        echo '</div>';
    } elseif ($status === "error") {
        // Display error message
        echo '<div class="alert alert-danger" role="alert">';
        echo 'Oops! Something went wrong. Please try again later.';
        echo '</div>';
    }
}
?>


<!-- <form method="post" action="deposit_process.php" name="spendform" class="makeBl"> -->
<form method="post" action="confirmation_page.php" name="spendform" class="makeBl" enctype="multipart/form-data">
<input type="hidden" name="userid" value="<?php echo $_SESSION['userid']; ?>">


    <div class="left">
        <h2 class="capTitleIn">Select plan</h2>
        <div class="selectBlock">
                        <div class="list">
                        <?php
                                // Fetch all investment plans from the database
                                $query = "SELECT plan_title, minimum, maximum, roi FROM plans";
                                $result = $conn->query($query);
                                while ($row = $result->fetch_assoc()) {
                                    // Output each investment plan as a button with data attributes for additional information
                                    echo '<div class="item">';
                                    echo '<input type="radio" class="checkBtn checkPlan" name="h_id" id="plan_' . htmlspecialchars($row['plan_title']) . '" value="' . htmlspecialchars($row['plan_title']) . '" data-days="1" data-perc="' . htmlspecialchars($row['roi']) . '" data-min="' . htmlspecialchars($row['minimum']) . '" data-max="' . htmlspecialchars($row['maximum']) . '" data-period="" data-name="' . htmlspecialchars($row['plan_title']) . '">';
                                    echo '<label for="plan_' . htmlspecialchars($row['plan_title']) . '" data-name="' . htmlspecialchars($row['plan_title']) . '" data-pr="' . htmlspecialchars($row['roi']) . '%" data-day="24 hours" data-min="' . htmlspecialchars($row['minimum']) . '$" data-max="' . htmlspecialchars($row['maximum']) . '$"></label>';
                                    echo '<div class="value">';
                                    echo '<span class="val">' . htmlspecialchars($row['minimum']) . '$</span>';
                                    echo '</div>';
                                    // Calculate the total profit for the current plan
                                    $total_profit = number_format(($row['minimum']), 2); // As per your requirement, total profit is just the minimum investment
                                    // Display the total profit with background styling
                                    echo '<div class="total-profit" style="display: none;"><span class="cur" style="background: url(\'background-image-url\') repeat;">' . $total_profit . '</span></div>';
                                    echo '</div>';
                                }
                                ?>
                        </div>
                    </div>

                    <div class="vipSelect">
                    <?php
    // VIP section
    $vip_query = "SELECT plan_title, minimum, maximum, roi FROM plans WHERE minimum IN (3000, 4000, 5000) ORDER BY minimum ASC";
    $vip_result = $conn->query($vip_query);
    while ($vip_row = $vip_result->fetch_assoc()) {
        // Output each remaining regular investment plan as a VIP option
        echo '<div class="item">';
        echo '<input type="radio" class="checkBtn checkPlan" name="h_id" id="depVip_' . htmlspecialchars($vip_row['plan_title']) . '" value="' . htmlspecialchars($vip_row['plan_title']) . '" data-days="1" data-perc="' . htmlspecialchars($vip_row['roi']) . '" data-min="' . htmlspecialchars($vip_row['minimum']) . '" data-max="' . htmlspecialchars($vip_row['maximum']) . '" data-period="" data-name="' . htmlspecialchars($vip_row['plan_title']) . '">';
        echo '<label for="depVip_' . htmlspecialchars($vip_row['plan_title']) . '" data-name="' . htmlspecialchars($vip_row['plan_title']) . '" data-pr="' . htmlspecialchars($vip_row['roi']) . '%" data-day="24 hours" data-min="' . htmlspecialchars($vip_row['minimum']) . '$" data-max="' . htmlspecialchars($vip_row['maximum']) . '$"></label>';
        echo '<div class="value">';
        // Calculate the amount as the minimum multiplied by ROI
        $vip_amount = $vip_row['minimum'];

        // Display the minimum investment amount without any additional text
        echo '<span class="val">' . htmlspecialchars($vip_amount) . '$</span>';

        echo '</div>';
        // Calculate the total profit for the current plan
        $vip_total_profit = number_format(($vip_amount - $vip_row['minimum']), 2);
        // Display the total profit with background styling
        echo '<div class="total-profit" style="display: none;"><span class="cur" style="background: url(\'background-image-url\') repeat;">' . $vip_total_profit . '</span></div>';
        echo '</div>';
    }
    ?>
    </div>



    <div class="info">
        <span class="name"></span>
        <ul>
            <li><span class="tit">Total percent: </span><span class="pr"></span></li>
            <li><span class="tit">Minimum: </span><span class="minvl"></span></li>
            <li><span class="tit">Deposit term: </span><span class="day"></span></li>
            <li><span class="tit">Maximum: </span><span class="maxvl"></span></li>
        </ul>
        <span class="desr">Deposit included in payments</span>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const planInputs = document.querySelectorAll('.checkPlan');
            const info = document.querySelector('.info');

            planInputs.forEach(function(input) {
                input.addEventListener('click', function() {
                    const planTitle = this.getAttribute('data-name');
                    const totalPercent = parseFloat(this.getAttribute('data-perc'));
                    const minimumAmount = parseFloat(this.getAttribute('data-min'));
                    const depositTerm = parseFloat(this.getAttribute('data-days'));
                    const maximumAmount = parseFloat(this.getAttribute('data-max'));

                    // Show the hidden info div
                    info.style.display = 'block';

                    // Update input fields with selected plan data
                    info.querySelector('.name').textContent = planTitle;
                    info.querySelector('.pr').textContent = totalPercent + "%";
                    info.querySelector('.minvl').textContent = minimumAmount.toLocaleString() + "$";
                    info.querySelector('.day').textContent = depositTerm + " days";
                    info.querySelector('.maxvl').textContent = maximumAmount.toLocaleString() + "$";
                });
            });
        });
    </script>



    </div>
    
    <div class="right">
   

<?php
                    // Fetch the first plan's title, minimum amount, and ROI from the plans table
                    $query = "SELECT plan_title, minimum, roi FROM plans LIMIT 1";
                    $result = mysqli_query($conn, $query);
                    $first_plan = mysqli_fetch_assoc($result);
                    ?>
                    
                    <form id="deposit_form" action="confirmation_page.php" method="post" class="calcTotal">
                    <div class="col">
                        <div class="inputLine">
                            <label for="plan_title">Plan Title:</label>
                            <input type="text" name="plan_title" id="plan_title" class="enterNum" value="<?php echo htmlspecialchars($first_plan['plan_title']); ?>" readonly>           
                        </div>
                    </div>
                    <div class="col">
                        <div class="inputLine">
                            <label for="calc_amount">Amount:</label>
                            <input type="text" name="amount" id="calc_amount" class="enterNum" value="<?php echo htmlspecialchars($first_plan['minimum']); ?>" readonly>
                            <span class="cur">$</span>
                        </div>
                    </div>
                    <div class="col">
                        <div class="lineSumma">
                            <span class="tit">Total profit:</span>
                            <span class="value">
                                <span class="sum" data-sum="00.00" id="profit_total"></span>
                                <span class="cur">$</span>
                            </span>
                        </div>
                        </div>
                        <div class="col">
                        <div class="btnLine">
                            <div class="info">
                                <span class="tit">Total percent:</span>
                                <span class="pr" id="percent_total"><?php echo $first_plan['roi']; ?>%</span>
                            </div>
                            <button type="submit" id="make_deposit_btn" class="btn btnGreen">Make deposit</button>
                        </div>
                        </div>
                        <!-- Display error message here -->
                        <div id="error_message" style="color: red; margin-top: 5px;"></div>
                        <input type="submit" style="display: none;" id="calc_btn">
                    </form>

<script>
   // JavaScript to handle plan selection
document.addEventListener('DOMContentLoaded', function() {
    const planInputs = document.querySelectorAll('.checkPlan');
    let totalRoi = 0;

    planInputs.forEach(function(input) {
        input.addEventListener('click', function() {
            const planTitle = this.getAttribute('data-name');
            const minimumAmount = parseFloat(this.getAttribute('data-min'));
            const roi = parseFloat(this.getAttribute('data-perc'));

            // Update plan title and minimum amount fields
            document.getElementById('plan_title').value = planTitle;
            document.getElementById('calc_amount').value = minimumAmount;
            document.getElementById('percent_total').textContent = roi + "%";

            // Update total profit based on selected plan
            const profitTotal = (minimumAmount * roi) / 100;
            document.getElementById('profit_total').textContent = profitTotal.toFixed(2);
            totalRoi = roi;

            // Reset error message if any
            document.getElementById('error_message').textContent = '';
        });
    });

    // Calculate total profit when the deposit form is submitted
    document.getElementById('deposit_form').addEventListener('submit', function(event) {
        event.preventDefault();

        const amount = parseFloat(document.getElementById('calc_amount').value);

        // Validate amount
        if (isNaN(amount) || amount <= 0) {
            document.getElementById('error_message').textContent = 'Please enter a valid amount.';
            return;
        }

        // Calculate total profit based on selected plan
        const profitTotal = (amount * totalRoi) / 100;
        document.getElementById('profit_total').textContent = profitTotal.toFixed(2);

        // Submit the form
        document.getElementById('calc_btn').click();
    });

    // Make deposit button click handler
    document.getElementById('make_deposit_btn').addEventListener('click', function() {
        // Trigger form submission
        document.getElementById('deposit_form').submit();
    });
});
</script>



    </div>
</form>



<div class="lineRightLk">
                <div class="infoLine">
                    <div class="top">
                        <div class="socialBl">
                            <ul>
                                <li><a href="https://t.me/fzjoseph"><span class="iconBl icon-telegram"></span></a></li>
                            </ul>
                        </div>
                        <div class="timeBlock">
                            <span class="iconBl icon-clock-29"></span>
                            <span id="date"><span></span></span>
                            <span id="time"><span><span class="dot">:</span><span class="dot">:</span></span></span>
                        </div>
                        <div class="linksBlock">
                            <ul>
                                <li>
                                    <span class="iconBl icon-mail-6"></span>
                                    <span class="tit">E-mail: </span>
                                    <a href="mailto:bitmaven01@gmail.com" class="mail">bitmaven01@gmail.com</a>
                                </li>
                                <li>
                                    <span class="iconBl icon-calendar-50"></span>
                                    <span class="tit">Working days: </span>
                                    <span class="txt">Daily<br> 24/7</span>
                                </li>
                            </ul>
                        </div>
                        <div class="copy"><p>© 2013 - <script> document.write(new Date().getFullYear())</script> Copyright <a href="https://www.openartminting.art" class="light text-decoration-none">Wealthwisedigitalinvestment</a>. All rights reserved </p></div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <script>
        $('#balance').hide();
        $('#infodata').hide();
        $.ajax({
            url: "?a=account",
            context: document.body
        }).done(function(data) {
            $('#balance').html($(data).find('#balance').html()).show();
            $('#infodata').html($(data).find('#infodata').html()).show();
        });
    </script>
</body>
</html>
