<?php
// Include database connection
include_once('_db.php');

// Check if the wallet_type parameter is set in the GET request
if (isset($_GET['wallet_type']) && !empty($_GET['wallet_type'])) {
    // Sanitize the input to prevent SQL injection
    $wallet_type = $_GET['wallet_type'];

    // Prepare and execute SQL query to fetch the wallet address based on the wallet type
    $query = "SELECT wallet_address FROM wallet WHERE wallet_type = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("s", $wallet_type);
    $stmt->execute();
    $stmt->store_result();

    // Check if any rows were returned
    if ($stmt->num_rows > 0) {
        // Fetch the wallet address
        $stmt->bind_result($wallet_address);
        $stmt->fetch();

        // Return the wallet address as the response
        echo $wallet_address;
    } else {
        // If no wallet address was found for the given wallet type, return a message
        echo "No wallet address found for the selected wallet type.";
    }
} else {
    // If the wallet type parameter is missing or empty, return an error message
    echo "Error: Wallet type parameter is missing or empty.";
}
?>
