<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

include_once('_db.php');

// Rest of your code...

// Function to fetch investment amounts from the database based on plan title
function getInvestmentAmounts($planTitle, $conn) {
    // Example query using plan title
    $query = "SELECT minimum, maximum, roi FROM plans WHERE plan_title = ?";
    
    // Prepare the statement
    $stmt = $conn->prepare($query);
    
    // Bind parameters
    $stmt->bind_param("s", $planTitle);
    
    // Execute the statement
    $stmt->execute();
    
    // Get result
    $result = $stmt->get_result();
    
    // Fetch the result as an associative array
    $investmentAmounts = $result->fetch_assoc();
    
    return $investmentAmounts; // Return the fetched result
}

// Check if the form was submitted with a plan_title
if(isset($_POST['plan_title'])) {
    // Get the selected plan title from the form submission
    $planTitle = $_POST['plan_title'];

    // Call the function to get investment amounts
    $investmentAmounts = getInvestmentAmounts($planTitle, $conn);

    // Display the investment amounts
    if($investmentAmounts) {
        echo "Minimum Investment: $" . $investmentAmounts['minimum'] . "<br>";
        echo "Maximum Investment: $" . $investmentAmounts['maximum'] . "<br>";
        echo "Return on Investment: " . $investmentAmounts['roi'] . "%";
    } else {
        echo "Investment amounts not found for plan: " . $planTitle;
    }
} else {
    // Handle the case where plan_title is not set
    echo "No plan selected.";
}
?>
