<?php
session_start();

// Include your database connection file
include_once('_db.php');

// Check if the form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    try {
        // Retrieve form data including the user ID
        if (!isset($_POST['userid'])) {
            throw new Exception("User ID not found in form data.");
        }
        
        // Fetch the username from the database based on the userid
        $userid = $_POST['userid'];
        $stmt_username = $conn->prepare("SELECT username FROM user_login WHERE userid = ?");
        $stmt_username->bind_param("s", $userid); // Assuming userid is an integer
        $stmt_username->execute();
        $result = $stmt_username->get_result();
        $row = $result->fetch_assoc();
        if (!$row) {
            throw new Exception("Username not found in the database.");
        }
        $username = $row['username'];

        $amount = $_POST['amount'];
        $walletType = $_POST['wallet_type'];
        // Retrieve file data for proof of payment
        $proofOfPayment = $_FILES['proof_of_payment'];

        // Validate and sanitize the input data
        $amount = filter_var($amount, FILTER_VALIDATE_FLOAT);
        $walletType = filter_var($walletType, FILTER_SANITIZE_STRING);

        // Move uploaded file (proof of payment) to a specified directory
        $targetDir = "uploads/"; // Specify the directory where you want to store uploaded files
        $targetFile = $targetDir . basename($proofOfPayment["name"]);
        move_uploaded_file($proofOfPayment["tmp_name"], $targetFile);

        // Insert the deposit details into the database
        $deposit_id = md5(uniqid());
        $stmt = $conn->prepare("INSERT INTO deposit (userid, username, deposit_id, amount, wallet_type, proof_of_payment, wallet_address) VALUES (?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("sssssss", $userid, $username, $deposit_id, $amount, $walletType, $targetFile, $_POST['wallet_address_input']); // Assuming wallet_address_input is a string
        $stmt->execute();

        // Check if the insertion was successful
        if ($stmt->affected_rows > 0) {
            // Redirect to the deposit page with success status
            header("Location: deposit.php?status=success");
            exit();
        } else {
            // Redirect to the deposit page with error status
            header("Location: deposit.php?status=error");
            exit();
        }
    } catch (Exception $e) {
        // Handle exceptions
        echo "Exception: " . $e->getMessage();
    }
}
?>
