<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

@session_start();
// Check if the 'userid' session is not set
if (!isset($_SESSION['userid'])) {
    header("Location: ./login.php");
    exit();
}

include_once ('_db.php');

// Check if $_SESSION['wallet_type'] is set before using it
if (!isset($_SESSION['wallet_type'])) {
    // Redirect the user or handle the case where wallet_type is not set
    // For example:
    // header("Location: ./some_other_page.php");
    // exit();
    // Or set a default value
    $_SESSION['wallet_type'] = 'default_wallet_type';
}

// Retrieve selected plan information
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['wallet_type'])) {
    // Store the wallet_type in the session
    $_SESSION['wallet_type'] = $_POST['wallet_type'];
}

// Fetch wallet address from the database
$query = "SELECT wallet_address FROM wallet WHERE wallet_type = :wallet_type";
$stmt = $pdo->prepare($query);
$stmt->execute(array(':wallet_type' => $_SESSION['wallet_type']));
$walletInfo = $stmt->fetch(PDO::FETCH_ASSOC);
$walletAddress = $walletInfo['wallet_address'];
?>

<!DOCTYPE html>
<html lang="ru">
<head>
    <!-- Your head content here -->
</head>
<body>
    <section class="wrapper">
        <div class="lkPage">
            <!-- Your page content here -->
            <div class="lkRight">
                <h2 class="capTitle">Deposit Confirmation</h2>
                <div class="confirmation-info">
                    <?php if (isset($walletAddress)): ?>
                        <p>Wallet Address: <?php echo htmlspecialchars($walletAddress); ?></p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>
</body>
</html>
