<?php
// Start the session
session_start();

// Check if the 'userid' session is not set
if (!isset($_SESSION['userid'])) {
    header("Location: ./login.php");
    exit();
}

// Include database connection and other necessary files
include_once ('_db.php');

// Set the user ID from the session variable
$userid = $_SESSION['userid'];

?>

<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <title>Bitmaven</title>
    <meta content="width=1200" name="viewport">
    <meta name="format-detection" content="telephone=no">

    <link rel="shortcut icon" href="favicon.ico" type="image/x-icon">
    <link rel="icon" href="favicon.ico" type="image/x-icon">

    <link rel="stylesheet" type="text/css" href="fonts/icomoon/style.css" />
    <link rel="stylesheet" type="text/css" href="fonts/stylesheet.css" />
    <link rel="stylesheet" type="text/css" href="css/jquery-ui.min.css" />
    <link rel="stylesheet" type="text/css" href="css/selectric.css" />
    <link rel="stylesheet" type="text/css" href="css/owl.carousel.min.css" />
    <link rel="stylesheet" type="text/css" href="css/animate.css" />
    <link rel="stylesheet" type="text/css" href="css/style.css" />
    <link rel="stylesheet" type="text/css" href="css/responsive.css" />

    <!-- Include SweetAlert CSS and JS via CDN -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@10.16.3/dist/sweetalert2.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10.16.3/dist/sweetalert2.all.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/7.2.0/sweetalert2.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/7.2.0/sweetalert2.all.min.js"></script>

    <script type="text/javascript" src="js/jquery-3.3.1.min.js"></script>
    <script type="text/javascript" src="js/detect.min.js"></script>
    <script type="text/javascript" src="js/jquery-ui.min.js"></script>
    <script type="text/javascript" src="js/jquery.selectric.min.js"></script>
    <script type="text/javascript" src="js/owl.carousel.min.js"></script>
    <script type="text/javascript" src="js/clipboard.min.js"></script>
    <script type="text/javascript" src="js/wow.min.js"></script>
    <script type="text/javascript" src="js/clock.js"></script>
    <script type="text/javascript" src="js/modal.js"></script>

    
    <script type="text/javascript" src="js/script.js"></script>
    <script src="//code.tidio.co/okcjoxpwqcqjojyqeqtoy15nqmc3h3tq.js" async></script>

    <!-- <script src="//code.jivosite.com/widget/jaS5xGD7Od" async></script> -->

</head>
<body>
    <section class="wrapper">
        <div class="lkPage">
            <div class="lineLeftLk">
                <div class="logo invsLink">
                    <a href="dashboard.php?a=home"></a>
                    <img src="img/logo.png" alt="">
                </div>
                <button class="menuBtn">
                    <span></span>
                    <span></span>
                    <span></span>
                    <span></span>
                </button>
                <div class="menuLk">
                <ul>
                            <li class="invisLink active">
                                <a href="dashboard.php?a=account"></a>
                                <span class="iconBl icon-user-icon-3"></span>
                                <span class="txt">user<br> area</span>
                            </li>
                            <li class="invisLink">
                                <a href="deposit.php?a=deposit"></a>
                                <span class="iconBl icon-plus-icon"></span>
                                <span class="txt">make a<br> deposit</span>
                            </li>
                            <li class="invisLink">
                                <a href="inevest_now.php?a=deposit"></a>
                                <span class="iconBl icon-plus-icon"></span>
                                <span class="txt">make a<br> Invesment</span>
                            </li>
                            <li class="invisLink">
                                <a href="transaction.php?a=deposit_list"></a>
                                <span class="iconBl icon-files-and-folders-1"></span>
                                <span class="txt">your<br> deposit</span>
                            </li>
                            <li class="invisLink">
                                <a href="withdraw.php?a=withdraw"></a>
                                <span class="iconBl icon-business-and-finance-3"></span>
                                <span class="txt">withdraw<br> funds</span>
                            </li>
                            <li class="invisLink">
                                <a href="transaction.php?a=earnings"></a>
                                <span class="iconBl icon-time-and-date-1"></span>
                                <span class="txt">operation<br> history</span>
                            </li>
                            <!-- <li class="invisLink">
                                <a href="?a=referals"></a>
                                <span class="iconBl icon-business-and-finance-2"></span>
                                <span class="txt">referral<br> system</span>
                            </li> -->
                            <!-- <li class="invisLink">
                                <a href="?a=wallet"></a>
                                <span class="iconBl icon-maps-and-location"></span>
                                <span class="txt">connect<br> wallet</span>
                            </li> -->
                            <li class="invisLink">
                                <a href="?a=edit_account"></a>
                                <span class="iconBl icon-ui"></span>
                                <span class="txt">user<br> settings</span>
                            </li>
                            <!--<li class="invisLink">
                                <a href="?a=tell_friend"></a>
                                <span class="iconBl icon-business-and-finance-2"></span>
                                <span class="txt">Tell<br> friend</span>
                            </li>-->
                            <li class="invisLink">
                                <a href="logout.php?a=logout"></a>
                                <span class="iconBl icon-placeholder-44"></span>
                                <span class="txt">Logout</span>
                            </li>                            
                        </ul>
                </div>
            </div>
            <div class="lkLeft">
            <div class="welcomeBl">
                    <?php
                    // Assume $userid is the user's ID you want to retrieve details for

                    // Execute query to retrieve user information from user_login table based on userid
                    $sql = $conn->prepare("SELECT username, account_balance, created_at FROM user_login WHERE userid = ?");
                    $sql->bind_param("i", $userid);
                    $sql->execute();

                    // Store result
                    $sql->store_result();

                    // Check if there are any rows returned by the query
                    if ($sql->num_rows > 0) {
                        // Bind result variables
                        $sql->bind_result($username, $account_balance, $created_at);

                        // Fetch the row from the result set
                        $sql->fetch();
                    ?>
                        <span class="desr">Welcome,</span>
                        <span class="name"><?php echo $username; ?></span>
                        <ul>
                            <li>
                                <span class="tit">Registration date:</span>
                                <span class="time"><?php echo date('M-d-Y', strtotime($created_at)); ?></span>
                            </li>
                           
                        </ul>
                        <a href="index.php?a=home" class="btn btnYellow">Main page</a>
                </div>
                <div class="balanceBl" id="balance">
    <span class="tit">Your balance:</span>
    <span class="value">$ <?php echo number_format($result['account_balance'], 2); ?></span>
    <!-- <span class="value"></?php echo $row['username']; ?></span> -->
</div>
<?php
}
?>

                <div class="listBalance" id="infodata">
                    <div class="item">
                        <span class="iconBl" style="background-image: url(img/ps_g/18.png);"></span>
                        <span class="val">0.00 <span class="cur">$</span></span>
                    </div>
                    <div class="item">
                        <span class="iconBl" style="background-image: url(img/ps_g/43.png);"></span>
                        <span class="val">0.00 <span class="cur">$</span></span>
                    </div>
                    <div class="item">
                        <span class="iconBl" style="background-image: url(img/ps_g/48.png);"></span>
                        <span class="val">0.00 <span class="cur">$</span></span>
                    </div>
                    <div class="item">
                        <span class="iconBl" style="background-image: url(img/ps_g/68.png);"></span>
                        <span class="val">0.00 <span class="cur">$</span></span>
                    </div>
                    <div class="item">
                        <span class="iconBl" style="background-image: url(img/ps_g/79.png);"></span>
                        <span class="val">0.00 <span class="cur">$</span></span>
                    </div>
                    <div class="item">
                        <span class="iconBl" style="background-image: url(img/ps_g/69.png);"></span>
                        <span class="val">0.00 <span class="cur">$</span></span>
                    </div>
                    <div class="item">
                        <span class="iconBl" style="background-image: url(img/ps_g/77.png);"></span>
                        <span class="val">0.00 <span class="cur">$</span></span>
                    </div>
                </div>
            </div>
            <div class="lkRight">
                <h2 class="capTitle">Make a deposit</h2>
                <?php
                // Check if the status parameter is present in the URL
                if (isset($_GET['status'])) {
                    // Check the value of the status parameter
                    $status = $_GET['status'];
                    if ($status === "success") {
                        // Display success message with green background
                        echo '<div class="alert alert-success" role="alert" style="background-color: #d4edda; border-color: #c3e6cb; color: #155724;">';
                        echo 'Success! Your wallet will be credited once admin confirms your payment.';
                        echo '</div>';
                    } elseif ($status === "error") {
                        // Display error message
                        echo '<div class="alert alert-danger" role="alert">';
                        echo 'Oops! Something went wrong. Please try again later.';
                        echo '</div>';
                    }
                }
                ?>
                <!-- Deposit form -->
                <form method="post" action="deposit_process.php" name="spendform" class="makeBl" enctype="multipart/form-data">
                <input type="hidden" name="userid" value="<?php echo $_SESSION['userid']; ?>">
                <input type="hidden" name="username" value="<?php echo $_SESSION['username']; ?>">
                

                    <!-- Investment plans -->
                    <div class="left">
                        <h2 class="capTitleIn">Select plan</h2>
                        <div class="selectBlock">
                            <div class="list">
                            <?php
                                // Fetch all investment plans from the database
                                $query = "SELECT plan_title, minimum, maximum, roi FROM plans";
                                $result = $conn->query($query);
                                while ($row = $result->fetch_assoc()) {
                                    // Output each investment plan as a button with data attributes for additional information
                                    echo '<div class="item">';
                                    echo '<input type="radio" class="checkBtn checkPlan" name="h_id" id="plan_' . htmlspecialchars($row['plan_title']) . '" value="' . htmlspecialchars($row['plan_title']) . '" data-days="1" data-perc="' . htmlspecialchars($row['roi']) . '" data-min="' . htmlspecialchars($row['minimum']) . '" data-max="' . htmlspecialchars($row['maximum']) . '" data-period="" data-name="' . htmlspecialchars($row['plan_title']) . '">';
                                    echo '<label for="plan_' . htmlspecialchars($row['plan_title']) . '" data-name="' . htmlspecialchars($row['plan_title']) . '" data-pr="' . htmlspecialchars($row['roi']) . '%" data-day="24 hours" data-min="' . htmlspecialchars($row['minimum']) . '$" data-max="' . htmlspecialchars($row['maximum']) . '$"></label>';
                                    echo '<div class="value">';
                                    echo '<span class="val">' . htmlspecialchars($row['minimum']) . '$</span>';
                                    echo '</div>';
                                    // Calculate the total profit for the current plan
                                    $total_profit = number_format(($row['minimum']), 2); // As per your requirement, total profit is just the minimum investment
                                    // Display the total profit with background styling
                                    echo '<div class="total-profit" style="display: none;"><span class="cur" style="background: url(\'background-image-url\') repeat;">' . $total_profit . '</span></div>';
                                    echo '</div>';
                                }
                                ?>
                            </div>
                        </div>
                        <div class="vipSelect">
                    <?php
                    // VIP section
                    $vip_query = "SELECT plan_title, minimum, maximum, roi FROM plans WHERE minimum IN (3000, 4000, 5000) ORDER BY minimum ASC";
                    $vip_result = $conn->query($vip_query);
                    while ($vip_row = $vip_result->fetch_assoc()) {
                        // Output each remaining regular investment plan as a VIP option
                        echo '<div class="item">';
                        echo '<input type="radio" class="checkBtn checkPlan" name="h_id" id="depVip_' . htmlspecialchars($vip_row['plan_title']) . '" value="' . htmlspecialchars($vip_row['plan_title']) . '" data-days="1" data-perc="' . htmlspecialchars($vip_row['roi']) . '" data-min="' . htmlspecialchars($vip_row['minimum']) . '" data-max="' . htmlspecialchars($vip_row['maximum']) . '" data-period="" data-name="' . htmlspecialchars($vip_row['plan_title']) . '">';
                        echo '<label for="depVip_' . htmlspecialchars($vip_row['plan_title']) . '" data-name="' . htmlspecialchars($vip_row['plan_title']) . '" data-pr="' . htmlspecialchars($vip_row['roi']) . '%" data-day="24 hours" data-min="' . htmlspecialchars($vip_row['minimum']) . '$" data-max="' . htmlspecialchars($vip_row['maximum']) . '$"></label>';
                        echo '<div class="value">';
                        // Calculate the amount as the minimum multiplied by ROI
                        $vip_amount = $vip_row['minimum'];

                        // Display the minimum investment amount without any additional text
                        echo '<span class="val">' . htmlspecialchars($vip_amount) . '$</span>';

                        echo '</div>';
                        // Calculate the total profit for the current plan
                        $vip_total_profit = number_format(($vip_amount - $vip_row['minimum']), 2);
                        // Display the total profit with background styling
                        echo '<div class="total-profit" style="display: none;"><span class="cur" style="background: url(\'background-image-url\') repeat;">' . $vip_total_profit . '</span></div>';
                        echo '</div>';
                    }
                    ?>
                </div>
                        
                <div class="info">
        <span class="name"></span>
        <ul>
            <li><span class="tit">Total percent: </span><span class="pr"></span></li>
            <li><span class="tit">Minimum: </span><span class="minvl"></span></li>
            <li><span class="tit">Deposit term: </span><span class="day"></span></li>
            <li><span class="tit">Maximum: </span><span class="maxvl"></span></li>
        </ul>
        <span class="desr">Deposit included in payments</span>
    </div>

    
                    </div>
                    
                    <!-- Deposit details -->
                    <div class="right">
                        <div class="col">
                            <h2 class="capTitleIn">Enter amount</h2>
                            <div class="inputLine">
                                <label for="calc_amount">Amount:</label>
                                <input type="text" name="amount" value="0.00" id="calc_amount" class="enterNum">
                                <span class="cur">$</span>
                            </div>
                        </div>
                        <div class="col">
                            <h2 class="capTitleIn">Wallet Type</h2>
                            <div class="inputLine">
                                <label for="wallet_type">Select Wallet Type:</label>
                                <select class="selectricBl payMet1" name="wallet_type" id="wallet_type" onchange="getWalletAddress(this.value)">
                                    <option value="">Select Wallet Type</option> <!-- Add this line for the initial "Select Wallet Type" option -->
                                    <?php
                                    // Fetch wallet types from the database
                                    $stmt = $conn->prepare("SELECT DISTINCT wallet_type FROM wallet");
                                    $stmt->execute();
                                    $stmt->store_result();
                                    $stmt->bind_result($wallet_type);
                                    while ($stmt->fetch()) {
                                        echo '<option value="' . htmlspecialchars($wallet_type) . '">' . htmlspecialchars($wallet_type) . '</option>';
                                    }
                                    ?>
                                </select>
                                
                            </div>
                            <div id="wallet_address_container" style="margin-top: 15px;"></div>
                        </div>
                        <div class="col">
                            <h2 class="capTitleIn">Proof of Payment</h2>
                            <div class="inputLine">
                                <label for="proof_of_payment">Upload Proof of Payment:</label>
                                <input type="file" class="form-control" id="proof_of_payment" name="proof_of_payment">
                            </div>
                        </div>
                        <div class="bot">
                            <button type="submit" class="btn btnGreen">Make a deposit</button>
                        </div>
                    </div>
                </form>
                <script language=javascript>
                    for (i = 0; i<document.spendform.type.length; i++) {
                        if ((document.spendform.type[i].value.match(/^process_/))) {
                            document.spendform.type[i].checked = true;
                            break;
                        }
                    }
                    updateCompound();
                </script>
            </div>
            <div class="lineRightLk">
                <div class="infoLine">
                    <div class="top">
                        <div class="socialBl">
                            <ul>
                                <li><a href="https://t.me/fzjoseph"><span class="iconBl icon-telegram"></span></a></li>
                            </ul>
                        </div>
                        <div class="timeBlock">
                            <span class="iconBl icon-clock-29"></span>
                            <span id="date"><span></span></span>
                            <span id="time"><span><span class="dot">:</span><span class="dot">:</span></span></span>
                        </div>
                        <div class="linksBlock">
                            <ul>
                                <li>
                                    <span class="iconBl icon-mail-6"></span>
                                    <span class="tit">E-mail: </span>
                                    <a href="mailto:bitmaven01@gmail.com" class="mail">bitmaven01@gmail.com</a>
                                </li>
                                <li>
                                    <span class="iconBl icon-calendar-50"></span>
                                    <span class="tit">Working days: </span>
                                    <span class="txt">Daily<br> 24/7</span>
                                </li>
                            </ul>
                        </div>
                        <div class="copy"><p>© 2013 - <script> document.write(new Date().getFullYear())</script> Copyright <a href="https://www.bitmaven.org" class="light text-decoration-none">Wealthwisedigitalinvestment</a>. All rights reserved </p></div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--Start of Tawk.to Script-->

    <script>
        $('#balance').hide();
        $('#infodata').hide();
        $.ajax({
            url: "?a=account",
            context: document.body
        }).done(function(data) {
            $('#balance').html($(data).find('#balance').html()).show();
            $('#infodata').html($(data).find('#infodata').html()).show();
        });
    </script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const planInputs = document.querySelectorAll('.checkPlan');
            const info = document.querySelector('.info');

            planInputs.forEach(function(input) {
                input.addEventListener('click', function() {
                    const planTitle = this.getAttribute('data-name');
                    const totalPercent = parseFloat(this.getAttribute('data-perc'));
                    const minimumAmount = parseFloat(this.getAttribute('data-min'));
                    const depositTerm = parseFloat(this.getAttribute('data-days'));
                    const maximumAmount = parseFloat(this.getAttribute('data-max'));

                    // Show the hidden info div
                    info.style.display = 'block';

                    // Update input fields with selected plan data
                    info.querySelector('.name').textContent = planTitle;
                    info.querySelector('.pr').textContent = totalPercent + "%";
                    info.querySelector('.minvl').textContent = minimumAmount.toLocaleString() + "$";
                    info.querySelector('.day').textContent = depositTerm + " days";
                    info.querySelector('.maxvl').textContent = maximumAmount.toLocaleString() + "$";
                });
            });
        });
    </script>
    <script>
                                    function getWalletAddress(walletType) {
                                        var xhttp = new XMLHttpRequest();
                                        xhttp.onreadystatechange = function() {
                                            if (this.readyState == 4 && this.status == 200) {
                                                var walletAddress = this.responseText;
                                                
                                                // Create label element
                                                var label = document.createElement("label");
                                                label.innerHTML = "Wallet Address:";
                                                label.setAttribute("for", "wallet_address_input");
                                                
                                                // Create input field and set its attributes
                                                var inputField = document.createElement("input");
                                                inputField.setAttribute("type", "text");
                                                inputField.setAttribute("id", "wallet_address_input");
                                                inputField.setAttribute("name", "wallet_address_input");
                                                inputField.setAttribute("value", walletAddress);
                                                inputField.setAttribute("readonly", true);
                                                inputField.classList.add("form-control"); // Add Bootstrap class for styling
                                                
                                                // Create copy icon
                                                var copyIcon = document.createElement("i");
                                                copyIcon.className = "bi bi-files";
                                                copyIcon.style.marginLeft = "5px"; // Add some space between input field and icon
                                                copyIcon.style.cursor = "pointer"; // Change cursor to pointer
                                                copyIcon.onclick = function() {
                                                    inputField.select();
                                                    document.execCommand("copy");
                                                    alert("Wallet address copied to clipboard");
                                                };
                                                
                                                // Append label, input field, and copy icon to the container
                                                var container = document.getElementById("wallet_address_container");
                                                container.innerHTML = ''; // Clear previous content
                                                container.appendChild(label);
                                                container.appendChild(inputField);
                                                container.appendChild(copyIcon);
                                            }
                                        };
                                        xhttp.open("GET", "get_wallet_address.php?wallet_type=" + walletType, true);
                                        xhttp.send();
                                    }
                                </script>
</body>
</html>
