<?php
// Start the session
session_start();

// Check if the 'userid' session is not set
if (!isset($_SESSION['userid'])) {
    header("Location: ./login.php");
    exit();
}

// Include database connection and other necessary files
require_once('_db.php');

// Set the user ID from the session variable
$userid = $_SESSION['userid'];

// Fetch the last deposit date
$sqlLastDeposit = "SELECT MAX(created_at) AS last_deposit_date FROM deposit WHERE userid = ?";
$stmtLastDeposit = $conn->prepare($sqlLastDeposit);
$stmtLastDeposit->bind_param("i", $userid);
$stmtLastDeposit->execute();
$stmtLastDeposit->bind_result($lastDepositDate);
$stmtLastDeposit->fetch();
$stmtLastDeposit->close();

// Fetch the total deposit made by the user
$sqlTotalDeposit = "SELECT SUM(amount) AS total_deposit FROM deposit WHERE userid = ?";
$stmtTotalDeposit = $conn->prepare($sqlTotalDeposit);
$stmtTotalDeposit->bind_param("i", $userid);
$stmtTotalDeposit->execute();
$stmtTotalDeposit->bind_result($totalDeposit);
$stmtTotalDeposit->fetch();
$stmtTotalDeposit->close();


// Fetch the earned total (profit_balance) from the user_login table
$sqlEarnedTotal = "SELECT profit_balance FROM user_login WHERE userid = ?";
$stmtEarnedTotal = $conn->prepare($sqlEarnedTotal);
$stmtEarnedTotal->bind_param("i", $userid);
$stmtEarnedTotal->execute();
$stmtEarnedTotal->bind_result($earnedTotal);
$stmtEarnedTotal->fetch();
$stmtEarnedTotal->close();

// Fetch the pending withdrawal amount
$sqlPendingWithdrawal = "SELECT SUM(amount) AS pending_withdrawal FROM withdrawals WHERE userid = ? AND status = 'pending'";
$stmtPendingWithdrawal = $conn->prepare($sqlPendingWithdrawal);
$stmtPendingWithdrawal->bind_param("i", $userid);
$stmtPendingWithdrawal->execute();
$stmtPendingWithdrawal->bind_result($pendingWithdrawal);
$stmtPendingWithdrawal->fetch();
$stmtPendingWithdrawal->close();

// Fetch the confirmed withdrawal amount
$sqlConfirmedWithdrawal = "SELECT SUM(amount) AS confirmed_withdrawal FROM withdrawals WHERE userid = ? AND status = 'confirmed'";
$stmtConfirmedWithdrawal = $conn->prepare($sqlConfirmedWithdrawal);
$stmtConfirmedWithdrawal->bind_param("i", $userid);
$stmtConfirmedWithdrawal->execute();
$stmtConfirmedWithdrawal->bind_result($confirmedWithdrawal);
$stmtConfirmedWithdrawal->fetch();
$stmtConfirmedWithdrawal->close();
?>


<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <title>Bitmaven</title>
    <meta content="width=1200" name="viewport">
    <meta name="format-detection" content="telephone=no">

    <link rel="shortcut icon" href="favicon.ico" type="image/x-icon">
    <link rel="icon" href="favicon.ico" type="image/x-icon">

    <link rel="stylesheet" type="text/css" href="fonts/icomoon/style.css" />
    <link rel="stylesheet" type="text/css" href="fonts/stylesheet.css" />
    <link rel="stylesheet" type="text/css" href="css/jquery-ui.min.css" />
    <link rel="stylesheet" type="text/css" href="css/selectric.css" />
    <link rel="stylesheet" type="text/css" href="css/owl.carousel.min.css" />
    <link rel="stylesheet" type="text/css" href="css/animate.css" />
    <link rel="stylesheet" type="text/css" href="css/style.css" />
    <link rel="stylesheet" type="text/css" href="css/responsive.css" />

     <!-- Include SweetAlert CSS and JS via CDN -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@10.16.3/dist/sweetalert2.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10.16.3/dist/sweetalert2.all.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/7.2.0/sweetalert2.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/7.2.0/sweetalert2.all.min.js"></script>

    <script type="text/javascript" src="js/jquery-3.3.1.min.js"></script>
    <script type="text/javascript" src="js/detect.min.js"></script>
    <script type="text/javascript" src="js/jquery-ui.min.js"></script>
    <script type="text/javascript" src="js/jquery.selectric.min.js"></script>
    <script type="text/javascript" src="js/owl.carousel.min.js"></script>
    <script type="text/javascript" src="js/clipboard.min.js"></script>
    <script type="text/javascript" src="js/wow.min.js"></script>
    <script type="text/javascript" src="js/clock.js"></script>
    <script type="text/javascript" src="js/modal.js"></script>

    
    <script type="text/javascript" src="js/script.js"></script>
    <script src="//code.tidio.co/dzmfhlkfzewp5malo3b7driuev8l2ipx.js" async></script>
    <!-- <script src="//code.jivosite.com/widget/jaS5xGD7Od" async></script> -->
</head>
<body>
    <section class="wrapper">
                    <div class="lkPage">
                <div class="lineLeftLk">
                    <div class="logo invsLink">
                        <a href="dashboard.php?a=home"></a>
                        <img src="img/logo.png" alt="">
                    </div>
                    <button class="menuBtn">
                        <span></span>
                        <span></span>
                        <span></span>
                        <span></span>
                    </button>
                    <div class="menuLk">
                    <ul>
                            <li class="invisLink active">
                                <a href="dashboard.php?a=account"></a>
                                <span class="iconBl icon-user-icon-3"></span>
                                <span class="txt">user<br> area</span>
                            </li>
                            <li class="invisLink">
                                <a href="deposit.php?a=deposit"></a>
                                <span class="iconBl icon-plus-icon"></span>
                                <span class="txt">make a<br> deposit</span>
                            </li>
                            <li class="invisLink">
                                <a href="inevest_now.php?a=deposit"></a>
                                <span class="iconBl icon-plus-icon"></span>
                                <span class="txt">make a<br> Invesment</span>
                            </li>
                            <li class="invisLink">
                                <a href="transaction.php?a=deposit_list"></a>
                                <span class="iconBl icon-files-and-folders-1"></span>
                                <span class="txt">your<br> deposit</span>
                            </li>
                            <li class="invisLink">
                                <a href="withdraw.php?a=withdraw"></a>
                                <span class="iconBl icon-business-and-finance-3"></span>
                                <span class="txt">withdraw<br> funds</span>
                            </li>
                            <li class="invisLink">
                                <a href="transaction.php?a=earnings"></a>
                                <span class="iconBl icon-time-and-date-1"></span>
                                <span class="txt">operation<br> history</span>
                            </li>
                            <!-- <li class="invisLink">
                                <a href="?a=referals"></a>
                                <span class="iconBl icon-business-and-finance-2"></span>
                                <span class="txt">referral<br> system</span>
                            </li> -->
                            <!-- <li class="invisLink">
                                <a href="?a=wallet"></a>
                                <span class="iconBl icon-maps-and-location"></span>
                                <span class="txt">connect<br> wallet</span>
                            </li> -->
                            
                            <!--<li class="invisLink">
                                <a href="?a=tell_friend"></a>
                                <span class="iconBl icon-business-and-finance-2"></span>
                                <span class="txt">Tell<br> friend</span>
                            </li>-->
                            <li class="invisLink">
                                <a href="logout.php?a=logout"></a>
                                <span class="iconBl icon-placeholder-44"></span>
                                <span class="txt">Logout</span>
                            </li>                            
                        </ul>
                    </div>
                </div>
                <div class="lkLeft">
                    <div class="welcomeBl">
                        
                        <?php
                            // Assume $userid is the user's ID you want to retrieve details for

                            // Execute query to retrieve user information from user_login table based on userid
                            $stmt = $conn->prepare("SELECT username, account_balance, created_at FROM user_login WHERE userid = ?");
                            $stmt->bind_param("i", $userid);
                            $stmt->execute();
                            $result = $stmt->get_result()->fetch_assoc();
                            $stmt->close();

                            // Check if there are any rows returned by the query
                            if ($result) {
                            ?>
                                <span class="desr">Welcome,</span>
                                <span class="name"><?php echo $result['username']; ?></span>
                                <ul>
                                    <li>
                                        <span class="tit">Registration date:</span>
                                        <span class="time"><?php echo date('M-d-Y', strtotime($result['created_at'])); ?></span>
                                    </li>
                                    <!-- <li>
                                        <span class="tit">Last seen:</span>
                                        <span class="time">n/a </span>
                                    </li> -->
                                </ul>
                            

                        <a href="index.php?a=home" class="btn btnYellow">Main page</a>
                    </div>  
                    <div class="balanceBl" id="balance">
                            <span class="tit">Your balance:</span>
                            <!-- <span class="value">$ </?php echo number_format($row['account_balance'], 2); ?></span> -->
                            <span class="value">$ <?php echo number_format($result['account_balance'], 2); ?></span>

                            <!-- <span class="value"></?php echo $row['username']; ?></span> -->
                        </div>
                        <?php
                        }
                        ?>
                     <div class="listBalance" id="infodata">
                                                    <div class="item">
                                <span class="iconBl" style="background-image: url(img/ps_g/18.png);"></span>
                                <span class="val">0.00 <span class="cur">$</span></span>
                            </div>
                                                    <div class="item">
                                <span class="iconBl" style="background-image: url(img/ps_g/43.png);"></span>
                                <span class="val">0.00 <span class="cur">$</span></span>
                            </div>
                                                    <div class="item">
                                <span class="iconBl" style="background-image: url(img/ps_g/48.png);"></span>
                                <span class="val">0.00 <span class="cur">$</span></span>
                            </div>
                                                    <div class="item">
                                <span class="iconBl" style="background-image: url(img/ps_g/68.png);"></span>
                                <span class="val">0.00 <span class="cur">$</span></span>
                            </div>
                                                    <div class="item">
                                <span class="iconBl" style="background-image: url(img/ps_g/79.png);"></span>
                                <span class="val">0.00 <span class="cur">$</span></span>
                            </div>
                                                    <div class="item">
                                <span class="iconBl" style="background-image: url(img/ps_g/69.png);"></span>
                                <span class="val">0.00 <span class="cur">$</span></span>
                            </div>
                                                    <div class="item">
                                <span class="iconBl" style="background-image: url(img/ps_g/77.png);"></span>
                                <span class="val">0.00 <span class="cur">$</span></span>
                            </div>
                             </div>
                </div>
                <div class="lkRight">
        

  


<h2 class="capTitle">User area</h2>
<div class="accountBl">
    <div class="left">
    <div class="col colorGreen">
    <div class="line">
        <span class="iconBl icon-upload-3"></span>
        <span class="tit">Last deposit</span>
        <span class="val"><?php echo $lastDepositDate ? date("Y-m-d", strtotime($lastDepositDate)) : 'n/a'; ?><span class="cur">$</span></span>
    </div>

    <div class="line">
        <span class="iconBl icon-upload-3"></span>
        <span class="tit">Total deposit</span>
        <span class="val"><?php echo $totalDeposit ? number_format($totalDeposit, 2) : '0.00'; ?><span class="cur">$</span></span>
    </div>
</div>
        <div class="col colorYellow">
        <div class="line">
    <span class="iconBl icon-download-16"></span>
    <span class="tit">Earned total</span>
    <span class="val"><?php echo number_format($earnedTotal, 2); ?><span class="cur">$</span></span>
</div>
<div class="line">
    <span class="iconBl icon-download-16"></span>
    <span class="tit">Pending withdrawal</span>
    <span class="val"><?php echo number_format($pendingWithdrawal, 2); ?><span class="cur">$</span></span>
</div>
<div class="line">
    <span class="iconBl icon-download-16"></span>
    <span class="tit">Withdraw total</span>
    <span class="val"><?php echo number_format($confirmedWithdrawal, 2); ?><span class="cur">$</span></span>
</div>

        </div>
    </div>
    <div class="right">
        <div class="youline" id="upline">
            <span class="iconBl fonicon1 icon-user-33"></span>
            <ul>
                <li>
                    <span class="tit">Your upline:</span>
                                            <span class="name"></span>                        
                                    
                </li>

            </ul>
        </div>
    </div>
</div>

    <!-- <a href="?a=referallinks" class="btn btnGreen">Promo banners</a> -->
</div>

<script>
    $.ajax({
        url: "?a=referals",
        context: document.body
    }).done(function(data) {      
        $('#upline').html($(data).find('#upline').html());            
    });
</script>


    
            </div>
            <div class="lineRightLk">
                <div class="infoLine">
                    <div class="top">
                        <div class="socialBl">
                            <ul>
                               
                                <li><a href="#"><span class="iconBl icon-telegram"></span></a></li>
                                    
                            </ul>
                        </div>
                        <div class="timeBlock">
                            <span class="iconBl icon-clock-29"></span>
                            <span id="date"><span></span></span>
                            <span id="time"><span><span class="dot">:</span><span class="dot">:</span></span></span>
                        </div>
                        <div class="linksBlock">
                            <ul>
                                
                                <li>
                                    <span class="iconBl icon-mail-6"></span>
                                    <span class="tit">E-mail: </span>
                                    <a href="mailto:bitmaven01@gmail.com" class="mail">bitmaven01@gmail.com</a>
                                </li>
                                <li>
                                    <span class="iconBl icon-calendar-50"></span>
                                    <span class="tit">Working days: </span>
                                    <span class="txt">Daily<br> 24/7</span>
                                </li>
                            </ul>
                        </div>
                        <div class="copy"><p> Copyright &copy;2008 <br> Eco Trade Option</p></div>
                    </div>
                </div>
            </div>
        </div>

    </section>
<!--Start of Tawk.to Script-->
<!-- <script type="text/javascript">
    var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
    (function(){
        var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
        s1.async=true;
        s1.src='https://embed.tawk.to/663575c307f59932ab3bb03c/default';
        s1.charset='UTF-8';
        s1.setAttribute('crossorigin','*');
        s0.parentNode.insertBefore(s1,s0);
    })();
</script> -->
       
    </body>
    
</html>
