<?php
// Start the session
session_start();

// Check if the user is logged in
if (!isset($_SESSION['userid'])) {
    header("Location: login.php");
    exit();
}

// Include database connection and other necessary files
include_once ('_db.php');

// Set the user ID from the session variable
$userid = $_SESSION['userid'];
// Retrieve form data
$planTitle = $_POST['plan_title'];
$investmentAmount = $_POST['amount'];

// Calculate total profit
// Assuming you have the ROI for the selected plan available
// Replace $roi with the actual ROI value for the selected plan
$roi = 11; // Example ROI value, replace with actual value
$totalProfit = $investmentAmount * $roi;
?>


<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <title>Bitmaven </title>
    <meta content="width=1200" name="viewport">
    <meta name="format-detection" content="telephone=no">

    <link rel="shortcut icon" href="favicon.ico" type="image/x-icon">
    <link rel="icon" href="favicon.ico" type="image/x-icon">

    <link rel="stylesheet" type="text/css" href="fonts/icomoon/style.css" />
    <link rel="stylesheet" type="text/css" href="fonts/stylesheet.css" />
    <link rel="stylesheet" type="text/css" href="css/jquery-ui.min.css" />
    <link rel="stylesheet" type="text/css" href="css/selectric.css" />
    <link rel="stylesheet" type="text/css" href="css/owl.carousel.min.css" />
    <link rel="stylesheet" type="text/css" href="css/animate.css" />
    <link rel="stylesheet" type="text/css" href="css/style.css" />
    <link rel="stylesheet" type="text/css" href="css/responsive.css" />

    <!-- Include SweetAlert CSS and JS via CDN -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@10.16.3/dist/sweetalert2.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10.16.3/dist/sweetalert2.all.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/7.2.0/sweetalert2.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/7.2.0/sweetalert2.all.min.js"></script>

    <script type="text/javascript" src="js/jquery-3.3.1.min.js"></script>
    <script type="text/javascript" src="js/detect.min.js"></script>
    <script type="text/javascript" src="js/jquery-ui.min.js"></script>
    <script type="text/javascript" src="js/jquery.selectric.min.js"></script>
    <script type="text/javascript" src="js/owl.carousel.min.js"></script>
    <script type="text/javascript" src="js/clipboard.min.js"></script>
    <script type="text/javascript" src="js/wow.min.js"></script>
    <script type="text/javascript" src="js/clock.js"></script>
    <script type="text/javascript" src="js/modal.js"></script>

    
    <script type="text/javascript" src="js/script.js"></script>
    <script src="//code.jivosite.com/widget/jaS5xGD7Od" async></script>

</head>
<body>
    <section class="wrapper">
                    <div class="lkPage">
                <div class="lineLeftLk">
                    <div class="logo invsLink">
                        <a href="dashboard.php?a=home"></a>
                        <img src="img/logo.png" alt="">
                    </div>
                    <button class="menuBtn">
                        <span></span>
                        <span></span>
                        <span></span>
                        <span></span>
                    </button>
                    <div class="menuLk">
                        <ul>
                            <li class="invisLink active">
                                <a href="dashboard.php?a=account"></a>
                                <span class="iconBl icon-user-icon-3"></span>
                                <span class="txt">user<br> area</span>
                            </li>
                            <li class="invisLink">
                                <a href="deposit.php?a=deposit"></a>
                                <span class="iconBl icon-plus-icon"></span>
                                <span class="txt">make a<br> deposit</span>
                            </li>
                            <li class="invisLink">
                                <a href="inevest_now.php?a=deposit"></a>
                                <span class="iconBl icon-plus-icon"></span>
                                <span class="txt">make a<br> Invesment</span>
                            </li>
                            <li class="invisLink">
                                <a href="transaction.php?a=deposit_list"></a>
                                <span class="iconBl icon-files-and-folders-1"></span>
                                <span class="txt">your<br> deposit</span>
                            </li>
                            <li class="invisLink">
                                <a href="withdraw.php?a=withdraw"></a>
                                <span class="iconBl icon-business-and-finance-3"></span>
                                <span class="txt">withdraw<br> funds</span>
                            </li>
                            <li class="invisLink">
                                <a href="transaction.php?a=earnings"></a>
                                <span class="iconBl icon-time-and-date-1"></span>
                                <span class="txt">operation<br> history</span>
                            </li>
                            <!-- <li class="invisLink">
                                <a href="?a=referals"></a>
                                <span class="iconBl icon-business-and-finance-2"></span>
                                <span class="txt">referral<br> system</span>
                            </li> -->
                            <!-- <li class="invisLink">
                                <a href="?a=wallet"></a>
                                <span class="iconBl icon-maps-and-location"></span>
                                <span class="txt">connect<br> wallet</span>
                            </li> -->
                            <li class="invisLink">
                                <a href="?a=edit_account"></a>
                                <span class="iconBl icon-ui"></span>
                                <span class="txt">user<br> settings</span>
                            </li>
                            <!--<li class="invisLink">
                                <a href="?a=tell_friend"></a>
                                <span class="iconBl icon-business-and-finance-2"></span>
                                <span class="txt">Tell<br> friend</span>
                            </li>-->
                            <li class="invisLink">
                                <a href="logout.php?a=logout"></a>
                                <span class="iconBl icon-placeholder-44"></span>
                                <span class="txt">Logout</span>
                            </li>                            
                        </ul>
                    </div>
            
                </div>
                <div class="lkLeft">
                <div class="welcomeBl">
                        
                        <?php
                            // Assume $userid is the user's ID you want to retrieve details for

                            // Execute query to retrieve user information from user_login table based on userid
                            $stmt = $conn->prepare("SELECT username, account_balance, created_at FROM user_login WHERE userid = ?");
                            $stmt->bind_param("i", $userid);
                            $stmt->execute();
                            $result = $stmt->get_result()->fetch_assoc();
                            $stmt->close();

                            // Check if there are any rows returned by the query
                            if ($result) {
                            ?>
                                <span class="desr">Welcome,</span>
                                <span class="name"><?php echo $result['username']; ?></span>
                                <ul>
                                    <li>
                                        <span class="tit">Registration date:</span>
                                        <span class="time"><?php echo date('M-d-Y', strtotime($result['created_at'])); ?></span>
                                    </li>
                                    <li>
                                        <span class="tit">Last seen:</span>
                                        <span class="time">n/a </span>
                                    </li>
                                </ul>
                            

                        <a href="index.php?a=home" class="btn btnYellow">Main page</a>
                    </div>  
                    <div class="balanceBl" id="balance">
    <span class="tit">Your balance:</span>
    <span class="value">$ <?php echo number_format($row['account_balance'], 2); ?></span>
    <!-- <span class="value"></?php echo $row['username']; ?></span> -->
</div>
<?php
}
?>
                            <div class="listBalance" id="infodata">
                                                    <div class="item">
                                <span class="iconBl" style="background-image: url(img/ps_g/18.png);"></span>
                                <span class="val">0.00 <span class="cur">$</span></span>
                            </div>
                                                    <div class="item">
                                <span class="iconBl" style="background-image: url(img/ps_g/43.png);"></span>
                                <span class="val">0.00 <span class="cur">$</span></span>
                            </div>
                                                    <div class="item">
                                <span class="iconBl" style="background-image: url(img/ps_g/48.png);"></span>
                                <span class="val">0.00 <span class="cur">$</span></span>
                            </div>
                                                    <div class="item">
                                <span class="iconBl" style="background-image: url(img/ps_g/68.png);"></span>
                                <span class="val">0.00 <span class="cur">$</span></span>
                            </div>
                                                    <div class="item">
                                <span class="iconBl" style="background-image: url(img/ps_g/79.png);"></span>
                                <span class="val">0.00 <span class="cur">$</span></span>
                            </div>
                                                    <div class="item">
                                <span class="iconBl" style="background-image: url(img/ps_g/69.png);"></span>
                                <span class="val">0.00 <span class="cur">$</span></span>
                            </div>
                                                    <div class="item">
                                <span class="iconBl" style="background-image: url(img/ps_g/77.png);"></span>
                                <span class="val">0.00 <span class="cur">$</span></span>
                            </div>
                        </div>
                </div>
  <div class="lkRight">
        

<h2 class="capTitle">Confirmation</h2>
    
<?php
// Check if the status parameter is present in the URL
if (isset($_GET['status'])) {
    // Check the value of the status parameter
    $status = $_GET['status'];
    if ($status === "success") {
        // Display success message for crypto investment
        echo '<div class="alert alert-success" role="alert" style="background-color: #d4edda; border-color: #c3e6cb; color: #155724;">';
        echo 'Success! Your investment has been made. Your wallet will be credited once the transaction is confirmed by the Admin.';
        echo '</div>';
    } elseif ($status === "error") {
        // Display error message
        echo '<div class="alert alert-danger" role="alert">';
        echo 'Oops! Something went wrong. Please try again later.';
        echo '</div>';
    }
}
?>


<!-- <form method="post" action="deposit_process.php" name="spendform" class="makeBl"> -->
<!-- Form for confirming payment -->
<form action="process_investment.php" method="post" enctype="multipart/form-data">

    <!-- Hidden fields -->
    <input type="hidden" name="userid" value="<?php echo $_SESSION['userid']; ?>">
    <input type="hidden" name="plan_title" value="<?php echo $planTitle; ?>">
        <input type="hidden" name="amount" value="<?php echo $investmentAmount; ?>">
        <input type="hidden" name="total_profit" value="<?php echo $totalProfit; ?>">
    <div class="left">
        <!-- <h2 class="capTitleIn">Select plan</h2> -->
        
    <p>You have selected the <?php echo $planTitle; ?> plan with an investment of $<?php echo $investmentAmount; ?>.</p>
    <p>Your total profit is $<?php echo number_format($totalProfit, 2); ?>.</p>
        
    </div>
  

    <div class="right">

    
    <div class="col">
        <!-- <h2 class="capTitleIn">Wallet Type</h2> -->
        <div class="inputLine">
            <label for="wallet_type">Select Wallet Type:</label>
            <select class="selectricBl payMet1" name="wallet_type" id="wallet_type" onchange="getWalletAddress(this.value)">
    <option value="">Select Wallet Type</option> <!-- Add this line for the initial "Select Wallet Type" option -->
    <?php
    // Fetch wallet types from the database
    $query = "SELECT DISTINCT wallet_type FROM wallet";
    $result = $conn->query($query);
    while ($row = $result->fetch_assoc()) {
        echo '<option value="' . htmlspecialchars($row['wallet_type']) . '">' . htmlspecialchars($row['wallet_type']) . '</option>';
    }
    ?>
</select>

<script>
    function getWalletAddress(walletType) {
        var xhttp = new XMLHttpRequest();
        xhttp.onreadystatechange = function() {
            if (this.readyState == 4 && this.status == 200) {
                var walletAddress = this.responseText;
                
                // Create label element
                var label = document.createElement("label");
                label.innerHTML = "Wallet Address:";
                label.setAttribute("for", "wallet_address_input");
                
                // Create input field and set its attributes
                var inputField = document.createElement("input");
                inputField.setAttribute("type", "text");
                inputField.setAttribute("id", "wallet_address_input");
                inputField.setAttribute("name", "wallet_address_input");
                inputField.setAttribute("value", walletAddress);
                inputField.setAttribute("readonly", true);
                inputField.classList.add("form-control"); // Add Bootstrap class for styling
                
                // Create copy icon
                var copyIcon = document.createElement("i");
                copyIcon.className = "bi bi-files";
                copyIcon.style.marginLeft = "5px"; // Add some space between input field and icon
                copyIcon.style.cursor = "pointer"; // Change cursor to pointer
                copyIcon.onclick = function() {
                    inputField.select();
                    document.execCommand("copy");
                    alert("Wallet address copied to clipboard");
                };
                
                // Append label, input field, and copy icon to the container
                var container = document.getElementById("wallet_address_container");
                container.innerHTML = ''; // Clear previous content
                container.appendChild(label);
                container.appendChild(inputField);
                container.appendChild(copyIcon);
            }
        };
        xhttp.open("GET", "get_wallet_address.php?wallet_type=" + walletType, true);
        xhttp.send();
    }
</script>
  

        </div>
        <div id="wallet_address_container" style="margin-top: 15px;"></div>
    </div>

    <div class="col">
        <!-- <h2 class="capTitleIn">Proof of Payment</h2> -->
        <div class="inputLine">
            <label for="proof_of_payment">Upload Proof of Payment:</label>
            <input type="file" class="form-control" id="proof_of_payment" name="proof_of_payment">
        </div>
    </div>

    <?php
// Fetch the user's account balance
$stmt = $conn->prepare("SELECT account_balance FROM user_login WHERE userid = ?");
$stmt->bind_param("i", $userid); // Assuming $userid contains the user's ID
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $accountBalance = $row['account_balance'];
    echo "Account Balance: " . $accountBalance; // Debugging: Check if account balance is fetched
} else {
    echo "Error: Unable to fetch account balance";
}

// Close the statement and result set
$stmt->close();
$result->close();
?>

<div class="bot">
    <?php
    // Check if the user's account balance is sufficient
    if ($accountBalance >= $investmentAmount) {
        // If balance is sufficient, allow the user to invest
        echo '<button type="submit" class="btn btnGreen">Invest Now</button>';
    } else {
        // If balance is insufficient, display a message in red color
        echo '<p style="color: red;">Insufficient balance</p>';
    }
    ?>
</div>



</div>

</div>
        
</div>
   
</form>






<script language=javascript>
for (i = 0; i<document.spendform.type.length; i++) {
  if ((document.spendform.type[i].value.match(/^process_/))) {
    document.spendform.type[i].checked = true;
    break;
  }
}
updateCompound();
</script>


  </div>
 <div class="lineRightLk">
                <div class="infoLine">
                    <div class="top">
                        <div class="socialBl">
                            <ul>
                               
                                <li><a href="https://t.me/fzjoseph"><span class="iconBl icon-telegram"></span></a></li>
                                    
                            </ul>
                        </div>
                        <div class="timeBlock">
                            <span class="iconBl icon-clock-29"></span>
                            <span id="date"><span></span></span>
                            <span id="time"><span><span class="dot">:</span><span class="dot">:</span></span></span>
                        </div>
                        <div class="linksBlock">
                            <ul>
                                
                                <li>
                                    <span class="iconBl icon-mail-6"></span>
                                    <span class="tit">E-mail: </span>
                                    <a href="mailto:bitmaven01@gmail.com" class="mail">bitmaven01@gmail.com</a>
                                </li>
                                <li>
                                    <span class="iconBl icon-calendar-50"></span>
                                    <span class="tit">Working days: </span>
                                    <span class="txt">Daily<br> 24/7</span>
                                </li>
                            </ul>
                        </div>
                        <div class="copy"><p> Copyright &copy;2008 <br> Eco Trade Option</p></div>
                    </div>
                </div>
            </div>
        </div>
    </section>

            <script>
            $('#balance').hide();
            $('#infodata').hide();
            $.ajax({
                url: "?a=account",
                context: document.body
            }).done(function(data) {
                $('#balance').html($(data).find('#balance').html()).show();
                $('#infodata').html($(data).find('#infodata').html()).show();
            });
        </script>
 

     


<script language="javascript"><!--
function openCalculator(id)
{

  w = 225; h = 400;
  t = (screen.height-h-30)/2;
  l = (screen.width-w-30)/2;
  window.open('?a=calendar&type=' + id, 'calculator' + id, "top="+t+",left="+l+",width="+w+",height="+h+",resizable=1,scrollbars=0");


  
  for (i = 0; i < document.spendform.h_id.length; i++)
  {
    if (document.spendform.h_id[i].value == id)
    {
      document.spendform.h_id[i].checked = true;
    }
  }

  

}

function updateCompound() {
  var id = 0;
  var tt = document.spendform.h_id.type;
  if (tt && tt.toLowerCase() == 'hidden') {
    id = document.spendform.h_id.value;
  } else {
    for (i = 0; i < document.spendform.h_id.length; i++) {
      if (document.spendform.h_id[i].checked) {
        id = document.spendform.h_id[i].value;
      }
    }
  }

  var cpObj = document.getElementById('compound_percents');
  if (cpObj) {
    while (cpObj.options.length != 0) {
      cpObj.options[0] = null;
    }
  }

  if (cps[id] && cps[id].length > 0) {
    document.getElementById('coumpond_block').style.display = '';

    for (i in cps[id]) {
      cpObj.options[cpObj.options.length] = new Option(cps[id][i]);
    }
  } else {
    document.getElementById('coumpond_block').style.display = 'none';
  }
}
var cps = {};
</script>


    </body>
    
</html>