<?php
// Include database connection and other necessary files
include_once('_db.php');

// Get current timestamp
$currentTimestamp = time();

// Query profit_additions table for records where scheduled_time is in the past
$stmt = $conn->prepare("SELECT * FROM profit_additions WHERE scheduled_time <= ?");
$stmt->bind_param("i", $currentTimestamp);
$stmt->execute();
$result = $stmt->get_result();
$profitRecords = $result->fetch_all(MYSQLI_ASSOC);

// Process each record
foreach ($profitRecords as $record) {
    // Retrieve user ID and profit from the record
    $userid = $record['userid'];
    $profit = $record['profit'];

    // Update user's balance with the profit
    $stmt = $conn->prepare("UPDATE user_login SET account_balance = account_balance + ? WHERE id = ?");
    $stmt->bind_param("di", $profit, $userid);
    $stmt->execute();

    // Optionally, you can delete the processed record from the profit_additions table
    $stmt = $conn->prepare("DELETE FROM profit_additions WHERE id = ?");
    $stmt->bind_param("i", $record['id']);
    $stmt->execute();
}
?>
