<?php
// Include your database connection file
require_once('../_db.php');

// Start the session
session_start();

// Check if the form is submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['email']) && isset($_POST['password'])) {
    // Get user input
    $email = $_POST['email'];
    $password = $_POST['password'];

    // Validate user input (add more validation as needed)
    if (empty($email) || empty($password)) {
        header('Location: ../login.php?status=error&message=Enter all fields');
        exit;
    } else {
        // Perform database query to check user credentials (use prepared statements for security)
        $query = "SELECT userid, email, password, account_balance, status FROM user_login WHERE email = ?";
        $stmt = $conn->prepare($query);

        if ($stmt) {
            $stmt->bind_param("s", $email);
            $stmt->execute();
            $result = $stmt->get_result();
            $stmt->close();

            if ($result->num_rows > 0) {
                // User found, check password and status
                $user = $result->fetch_assoc();
                // Debugging statement to output the user data
                var_dump($user);
                if (password_verify($password, $user['password'])) {
                    if ($user['status'] === 'active') {
                        // Password is correct and status is active
                        $_SESSION['userid'] = $user['userid'];
                        $_SESSION['email'] = $user['email'];
                        $_SESSION['full_name'] = $user['full_name'];
                        $_SESSION['account_balance'] = $user['account_balance'];

                        header('Location: ../dashboard.php?status=success&message=Login SuccessFully');
                        exit;
                    } else {
                        // Status is pending
                        header('Location: ../login.php?status=error&message=Your account is pending approval');
                        exit;
                    }
                } else {
                    // Incorrect password
                    header('Location: ../login.php?status=error&message=Incorrect password');
                    exit;
                }
            } else {
                // User not found
                header('Location: ../login.php?status=error&message=User not found');
                exit;
            }
        } else {
            header('Location: ../login.php?status=error&message=Error in database query');
            exit;
        }
    }
} else {
    header('Location: ../login.php?status=error&message=Invalid request');
    exit;
}
?>
