<?php
// Include your database connection file
include_once("../_db.php");

// Check if form is submitted
if(isset($_POST['btnEditAmount'])) {
    // Retrieve form data
    $newBalance = $_POST['newBalance'];
    $newProfitBalance = $_POST['newProfitBalance']; // Add this line to get the new profit balance
    $id = $_POST['id']; // Assuming you're passing the user ID through the form

    // Update user's account balance and profit balance
    $sql = "UPDATE user_login SET account_balance = ?, profit_balance = ? WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sii", $newBalance, $newProfitBalance, $id); // Assuming 'id' is an integer

    if($stmt->execute()) {
        // Account balance and profit balance updated successfully
        // Redirect back to info.php
        header("Location: info.php");
        exit(); // Ensure script execution stops after redirection
    } else {
        // Error updating account balance
        echo "Error updating account balance: " . $conn->error;
    }

    // Close statement and connection
    $stmt->close();
    $conn->close();
}

// Retrieve the user ID from the URL parameter
$id = $_GET['id'];

// Fetch the user's current balance and profit balance
$sql = "SELECT account_balance, profit_balance FROM user_login WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id); // Assuming 'id' is an integer
$stmt->execute();
$stmt->bind_result($currentBalance, $currentProfitBalance); // Add this line to bind the result
$stmt->fetch();
$stmt->close();
?>


<?php
include 'head.php';
include 'header.php';
?>

<body class="skin-default fixed-layout">
    <div id="main-wrapper">
        <?php include 'sidebar.php'; ?>
        <div class="page-wrapper">
            <section>
                <div class="">
                    <?php include 'nav1.php'; ?>
                    <div class="container-fluid">
                        <div class="card">
                            <div class="card-header">
                                <!-- </?php echo isset($_SESSION['mgs']) ? $_SESSION['mgs'] : "" ?> -->
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table">
                                        <tbody>
                                            <!-- HTML Form for updating balance -->
                                            <form action="update_balance.php" method="post">
    <div class="form-group">
        <label for="newBalance">New Balance:</label>
        <input type="text" class="form-control" name="newBalance" value="<?php echo $currentBalance; ?>" required>
    </div>
    <div class="form-group">
        <label for="newProfitBalance">New Profit Balance:</label>
        <input type="text" class="form-control" name="newProfitBalance" value="<?php echo $currentProfitBalance; ?>" required>
    </div>
    <!-- Hidden input to pass user ID -->
    <input type="hidden" name="id" value="<?php echo $id; ?>">
    <button type="submit" name="btnEditAmount" class="btn btn-success">Update Balance</button>
</form>

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
    <?php include 'footer.php'; ?>
</body>
</html>
