<?php
// Include your database connection file here if not already included
include_once ("../_db.php");

session_start();


if(isset($_POST['btnEditAmount'])) {
    // Retrieve form data
    $newBalance = $_POST['newBalance'];
    $id = $_POST['id'];

    // Perform validation if necessary

    // Update user's account balance
    $sql = "UPDATE user_login SET account_balance = ? WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("di", $newBalance, $id);

    if($stmt->execute()) {
        // Account balance updated successfully
        $_SESSION['success_message'] = "Account balance updated successfully.";
    } else {
        // Error updating account balance
        $_SESSION['error_message'] = "Error updating account balance: " . $conn->error;
    }

    // Close statement and connection
    $stmt->close();
    $conn->close();

    // Redirect back to info.php
    header("Location: info.php");
    exit(); // Ensure script execution stops after redirection
}
?>
